#ifndef QCAP_BCB_H
#define QCAP_BCB_H

// BCB 2014 SUPPORT
// 
#undef QCAP_EXT_API 

#define QCAP_EXT_API

#define QCAP_EXPORT __stdcall

typedef unsigned short * WSTRING;
// RESULT OF FUNCTION
//
typedef enum {

	QCAP_RS_SUCCESSFUL								= 0x00000000,

	QCAP_RS_ERROR_GENERAL							= 0x00000001,

	QCAP_RS_ERROR_OUT_OF_MEMORY						= 0x00000002,

	QCAP_RS_ERROR_OUT_OF_RESOURCE					= 0x00000003,

	QCAP_RS_ERROR_INVALID_DEVICE					= 0x00000004,

	QCAP_RS_ERROR_INVALID_PARAMETER					= 0x00000005,

	QCAP_RS_ERROR_NON_SUPPORT						= 0x00000006,

	QCAP_RS_ERROR_TIMEOUT							= 0x00000007,

	QCAP_RS_ERROR_INVALID_ANIMATION_SCRIPT			= 0x00000008,

	QCAP_RS_ERROR_NO_SIGNAL_DETECTED				= 0x00000009,

	QCAP_RS_ERROR_NEED_MORE_DATA					= 0x0000000A,

	QCAP_RS_ERROR_CONNECT_FAIL						= 0x0000000B,

	QCAP_RS_ERROR_FILE_ACCESS_FAIL					= 0x0000000C,

	QCAP_RS_ERROR_NETWORK_ACCESS_FAIL				= 0x0000000D,

	QCAP_RS_ERROR_FILE_IS_BOX_MOVED					= 0x0000000E,

	QCAP_RS_ERROR_FRAME_IS_COPIED					= 0x0000000F,

	QCAP_RS_ERROR_VIDEO_ENCODER_ACCESS_FAIL			= 0x00000010,

	QCAP_RS_ERROR_AUDIO_ENCODER_ACCESS_FAIL			= 0x00000011,

	QCAP_RS_ERROR_NETWORK_CONNECT_UNKNOWN_FAIL		= 0x80000000,

	QCAP_RS_ERROR_NETWORK_CONNECT_URL_FAIL			= 0x80000001,

	QCAP_RS_ERROR_NETWORK_CONNECT_PASSWORD_FAIL		= 0x80000002,

	QCAP_RS_ERROR_NETWORK_CONNECT_SESSION_NAME_FAIL = 0x80000003,

} QRESULT;

// RETURN OF CALLBACK
//
typedef enum {

	QCAP_RT_OK					= 0x00000000,
	
	QCAP_RT_FAIL				= 0x00000001,

	QCAP_RT_SKIP_RECORD_NUM_00	= 0x00010002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_01	= 0x00020002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_02	= 0x00040002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_03	= 0x00080002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_DISPLAY		= 0x00000004, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK / 
											  //
											  //		  PF_VIDEO_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_BROADCAST_CLIENT_CALLBACK / 
											  //
											  //		  PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK /
											  //
											  //		  PF_VIDEO_DECODER_FILE_CALLBACK / PF_AUDIO_DECODER_FILE_CALLBACK
											  
	QCAP_RT_SKIP_CLONE_DISPLAY	= 0x00000008, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_00	= 0x01000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_01	= 0x02000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_02	= 0x04000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_03	= 0x08000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

} QRETURN;

// DEVICE ENUMERATION TYPE
//
enum {

	QCAP_ENUM_TYPE_DEVICE_NAME		= 0,

	QCAP_ENUM_TYPE_SERIAL_NUMBER	= 1,
};

// INPUT VIDEO SOURCE
//
enum {

	QCAP_INPUT_TYPE_COMPOSITE	 = 0,

	QCAP_INPUT_TYPE_SVIDEO		 = 1,

	QCAP_INPUT_TYPE_HDMI		 = 2,

	QCAP_INPUT_TYPE_DVI_D		 = 3,

	QCAP_INPUT_TYPE_COMPONENTS	 = 4,

	QCAP_INPUT_TYPE_YCBCR		 = 4,

	QCAP_INPUT_TYPE_DVI_A		 = 5,

	QCAP_INPUT_TYPE_RGB			 = 5,

	QCAP_INPUT_TYPE_VGA			 = 5,

	QCAP_INPUT_TYPE_SDI			 = 6,

	QCAP_INPUT_TYPE_DISPLAY_PORT = 8,

	QCAP_INPUT_TYPE_AUTO		 = 7,
};

// INPUT AUDIO SOURCE
//
enum {	

	QCAP_INPUT_TYPE_EMBEDDED_AUDIO			= 0,

	QCAP_INPUT_TYPE_LINE_IN					= 1,

	QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE	= 2,

	QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN		= 3,
};

// VIDEO STANDARD TYPE
//
enum {	

	QCAP_STANDARD_TYPE_NTSC_M		= 0x00000001,

	QCAP_STANDARD_TYPE_NTSC_M_J		= 0x00000002,

	QCAP_STANDARD_TYPE_NTSC_433		= 0x00000004,

	QCAP_STANDARD_TYPE_PAL_M		= 0x00000200,

	QCAP_STANDARD_TYPE_PAL_60		= 0x00000800,

	QCAP_STANDARD_TYPE_PAL_B		= 0x00000010,

	QCAP_STANDARD_TYPE_PAL_D		= 0x00000020,

	QCAP_STANDARD_TYPE_PAL_G		= 0x00000040,

	QCAP_STANDARD_TYPE_PAL_H		= 0x00000080,

	QCAP_STANDARD_TYPE_PAL_I		= 0x00000100,

	QCAP_STANDARD_TYPE_PAL_N		= 0x00000400,

	QCAP_STANDARD_TYPE_PAL_N_COMBO	= 0x00100000,

	QCAP_STANDARD_TYPE_AUTO			= 0x80000000, // DEFAULT, [P.S. SC310N8/N16            (CX2581 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC290N4/SC390N4/N8/N16 (AH8400 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC2B0N4/SC3B0N4/N8/N16 (TW5864 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3A0N4/N8/N16         (FH8735 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3C0N4/N8/N16         (MZ0380 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
};

// VIDEO DEINTERLACE TYPE
//
enum {	

	QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING			  = 0x00000000, // DEFAULT

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE	  = 0x00000001,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE	  = 0x00000002,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_BOB				  = 0x00000003,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MEDICAL_RGB_REPACK = 0x00000010, // DEVELOPING ...
};

// COLORRANGE TYPE
//
enum {

	QCAP_COLORRANGE_TYPE_FULL		        = 0, //  0 ~ 255 (ITU BT.709)

	QCAP_COLORRANGE_TYPE_LIMIT		        = 1, // 16 ~ 235 (ITU BT.709)

	QCAP_COLORRANGE_TYPE_FULL_BGR32	        = 2, //  0 ~ 255 (ITU BT.709) (RENDERER @ RGB32) 

	QCAP_COLORRANGE_TYPE_LIMIT_BGR32        = 3, // 16 ~ 235 (ITU BT.709) (RENDERER @ RGB32) 

	QCAP_COLORRANGE_TYPE_LIMIT_ITU601       = 5, // 16 ~ 235 (ITU BT.601)

	QCAP_COLORRANGE_TYPE_LIMIT_ITU601_BGR32 = 7, // 16 ~ 235 (ITU BT.601) (RENDERER @ RGB32)
};

// COLORSPACE TYPE
//
enum {

	QCAP_COLORSPACE_TYEP_RGB24	= 0,		  //   0xBBGGRR -> R0 G0 B0 R1 G1 B1 R2 G2 B2 ... >>

	QCAP_COLORSPACE_TYEP_BGR24	= 1,		  //   0xRRGGBB -> B0 G0 R0 B1 G1 R1 B2 G2 R2 ... >>

	QCAP_COLORSPACE_TYEP_ARGB32	= 2,		  // 0xAABBGGRR -> R0 G0 B0 A0 R1 G1 B1 A1 R2 G2 B2 A2 ... >>

	QCAP_COLORSPACE_TYEP_ABGR32	= 3,		  // 0xAARRGGBB -> B0 G0 R0 A0 B1 G1 R1 A1 B2 G2 R2 A2 ... >>

	QCAP_COLORSPACE_TYEP_YUY2	= 0x32595559, // 0x32595559 -> MAKEFOURCC('Y', 'U', 'Y', '2')

	QCAP_COLORSPACE_TYEP_UYVY	= 0x59565955, // 0x59565955 -> MAKEFOURCC('U', 'Y', 'V', 'Y')

	QCAP_COLORSPACE_TYEP_YV12	= 0x32315659, // 0x32315659 -> MAKEFOURCC('Y', 'V', '1', '2') (Y V U)

	QCAP_COLORSPACE_TYEP_I420	= 0x30323449, // 0x30323449 -> MAKEFOURCC('I', '4', '2', '0') -> Y U V

	QCAP_COLORSPACE_TYEP_Y800	= 0x30303859, // 0x30303859 -> MAKEFOURCC('Y', '8', '0', '0') -> Y

	QCAP_COLORSPACE_TYEP_MJPG	= 0x47504A4D, // 0x47504A4D -> MAKEFOURCC('M', 'J', 'P', 'G')

	QCAP_COLORSPACE_TYEP_H264	= 0x34363248, // 0x34363248 -> MAKEFOURCC('H', '2', '6', '4')

	QCAP_COLORSPACE_TYEP_H265	= 0x35363248, // 0x34363248 -> MAKEFOURCC('H', '2', '6', '5')
};

// ENCODER TYPE (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_TYPE_SOFTWARE			= 0,

	QCAP_ENCODER_TYPE_HARDWARE			= 1, // IT IS ONLY USED FOR HARDWARE COMPRESSION CAPTURE CARD, SUCH AS SC580 & SC590 & SC5A0 & SC5C0

	QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK	= 2,

	QCAP_ENCODER_TYPE_AMD_VCE			= 3,

	QCAP_ENCODER_TYPE_NVIDIA_CUDA		= 4,

	QCAP_ENCODER_TYPE_NVIDIA_NVENC		= 5,
};

// ENCODER VIDEO FORMAT (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_FORMAT_MPEG2		=  1,

	QCAP_ENCODER_FORMAT_H264		=  0,

	QCAP_ENCODER_FORMAT_H264_3D		=  2, // H264 MVC (STEREOSCOPIC 3D)

	QCAP_ENCODER_FORMAT_H264_VC		=  3, // H264 SVC (MULTIPLE TEMPORAL SCALABILITY)

	QCAP_ENCODER_FORMAT_RAW			=  4,

	QCAP_ENCODER_FORMAT_RAW_NATIVE	=  4,

	QCAP_ENCODER_FORMAT_H265		=  5,

	QCAP_ENCODER_FORMAT_RAW_YUY2	= 20,

	QCAP_ENCODER_FORMAT_RAW_UYVY	= 21, // DEVELOPING ...

	QCAP_ENCODER_FORMAT_RAW_YV12	= 22,

	QCAP_ENCODER_FORMAT_RAW_I420	= 23, // DEVELOPING ...

	QCAP_ENCODER_FORMAT_RAW_Y800	= 24,
};

// ENCODER AUDIO FORMAT (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_FORMAT_PCM			= 0,

	QCAP_ENCODER_FORMAT_AAC			= 1,

	QCAP_ENCODER_FORMAT_AAC_RAW		= 1,

	QCAP_ENCODER_FORMAT_AAC_ADTS	= 2,

	QCAP_ENCODER_FORMAT_MP2			= 4, // MPEG AUDIO LAYER 2

	QCAP_ENCODER_FORMAT_MP3			= 5, // MPEG AUDIO LAYER 3

	QCAP_ENCODER_FORMAT_OPUS		= 6,

	QCAP_ENCODER_FORMAT_AC3			= 7,
};

// RECORD PROFILE (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_PROFILE_BASELINE	         = 0, // DEFAULT

	QCAP_RECORD_PROFILE_MAIN		         = 1,

	QCAP_RECORD_PROFILE_HIGH		         = 2,

	QCAP_RECORD_PROFILE_CONSTRAINED_BASELINE = 3, // ONLY FOR QCAP_ENCODER_FORMAT_H264_VC

	QCAP_RECORD_PROFILE_CONSTRAINED_HIGH     = 4, // ONLY FOR QCAP_ENCODER_FORMAT_H264_VC
};

// RECORD LEVEL (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_LEVEL_1		= 10,

	QCAP_RECORD_LEVEL_1B	=  9,

	QCAP_RECORD_LEVEL_11	= 11,

	QCAP_RECORD_LEVEL_12	= 12,

	QCAP_RECORD_LEVEL_13	= 13,

	QCAP_RECORD_LEVEL_2		= 20,

	QCAP_RECORD_LEVEL_21	= 21,

	QCAP_RECORD_LEVEL_22	= 22,

	QCAP_RECORD_LEVEL_3		= 30,

	QCAP_RECORD_LEVEL_31	= 31,

	QCAP_RECORD_LEVEL_32	= 32,

	QCAP_RECORD_LEVEL_4		= 40,

	QCAP_RECORD_LEVEL_41	= 41, // DEFAULT

	QCAP_RECORD_LEVEL_42	= 42,

	QCAP_RECORD_LEVEL_50	= 50,

	QCAP_RECORD_LEVEL_51	= 51,

	QCAP_RECORD_LEVEL_52	= 52,

	QCAP_RECORD_LEVEL_60	= 60,

	QCAP_RECORD_LEVEL_61	= 61,

	QCAP_RECORD_LEVEL_62	= 62,
};

// RECORD ENTROPY (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_ENTROPY_CAVLC	= 0, // DEFAULT

	QCAP_RECORD_ENTROPY_CABAC	= 1,
};

// RECORD COMPLEXITY (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_COMPLEXITY_0	= 0, // BEST SPEED, DEFAULT

	QCAP_RECORD_COMPLEXITY_1	= 1,

	QCAP_RECORD_COMPLEXITY_2	= 2,

	QCAP_RECORD_COMPLEXITY_3	= 3,

	QCAP_RECORD_COMPLEXITY_4	= 4,

	QCAP_RECORD_COMPLEXITY_5	= 5,

	QCAP_RECORD_COMPLEXITY_6	= 6, // BEST QUALITY
};

// RECORD MODE (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_MODE_VBR		= 0, 

	QCAP_RECORD_MODE_CBR		= 1, 

	QCAP_RECORD_MODE_ABR		= 2, 

	QCAP_RECORD_MODE_CQP		= 3, // DEVELOPING ...

	QCAP_RECORD_MODE_LOSSLESS	= 4, 
};

// DOWNSCALE MODE (RECORD PROPERTY)
// 
enum {

	QCAP_DOWNSCALE_MODE_OFF	= 0, // (1920, 1080) * (1 / 1) = (1920, 1080)

	QCAP_DOWNSCALE_MODE_2_3	= 1, // (1920, 1080) * (2 / 3) = (1280,  720)

	QCAP_DOWNSCALE_MODE_1_2	= 2, // (1920, 1080) * (1 / 2) = ( 960,  540)

	QCAP_DOWNSCALE_MODE_1_4	= 3, // (1920, 1080) * (1 / 4) = ( 480,  270)
};

// RECORD FLAG (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_FLAG_FULL						= 0x00000007,

	QCAP_RECORD_FLAG_FILE						= 0x00000001,

	QCAP_RECORD_FLAG_ENCODE						= 0x00000002,

	QCAP_RECORD_FLAG_DISPLAY					= 0x00000004,

	QCAP_RECORD_FLAG_DECODE						= 0x00000008,

	QCAP_RECORD_FLAG_VIDEO_ONLY					= 0x00000010,

	QCAP_RECORD_FLAG_AUDIO_ONLY					= 0x00000020,

	QCAP_RECORD_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	= 0x00000040,

	QCAP_RECORD_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	= 0x00000080,

	QCAP_RECORD_FLAG_INGNORE_FORMAT_CHANGED		= 0x00000100,

	QCAP_RECORD_FLAG_SYNCHRONIZED_RECORD		= 0x00000200, // START BY QCAP_RESUME_RECORD

	QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER		= 0x00000400, // ONLY FOR QCAP_SET_VIDEO_*_UNCOMPRESSION_BUFFER_*

	QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER		= 0x00000800, // ONLY FOR QCAP_SET_AUDIO_*_UNCOMPRESSION_BUFFER_*
};

// BROADCAST FLAG (BROADCAST PROPERTY)
//
enum {

	QCAP_BROADCAST_FLAG_FULL						= 0x00000007,

	QCAP_BROADCAST_FLAG_NETWORK						= 0x00000001,

	QCAP_BROADCAST_FLAG_ENCODE						= 0x00000002,

	QCAP_BROADCAST_FLAG_DISPLAY						= 0x00000004,

	QCAP_BROADCAST_FLAG_DECODE						= 0x00000008,

	QCAP_BROADCAST_FLAG_VIDEO_ONLY					= 0x00000010,
	
	QCAP_BROADCAST_FLAG_AUDIO_ONLY					= 0x00000020,

	QCAP_BROADCAST_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	= 0x00000040,

	QCAP_BROADCAST_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	= 0x00000080,

	QCAP_BROADCAST_FLAG_VIDEO_USE_MEDIA_TIMER		= 0x00000400, // ONLY FOR QCAP_SET_VIDEO_*_UNCOMPRESSION_BUFFER_*

	QCAP_BROADCAST_FLAG_AUDIO_USE_MEDIA_TIMER		= 0x00000800, // ONLY FOR QCAP_SET_AUDIO_*_UNCOMPRESSION_BUFFER_*
};

// BROADCAST PROTOCOL (BROADCAST PROPERTY)
//
enum {

	QCAP_BROADCAST_PROTOCOL_UDP	 = 0x00000000,

	QCAP_BROADCAST_PROTOCOL_TCP	 = 0x00000001, // BPS >= 12MBPS, SUGGEST TO SUE QCAP_BROADCAST_PROTOCOL_TCP

	QCAP_BROADCAST_PROTOCOL_HTTP = 0x00000002,
};

// OSD FONT STYLE (OSD PROPERTY)
//
enum {

    QCAP_FONT_STYLE_REGULAR     = 0x00000000,
    
	QCAP_FONT_STYLE_BOLD        = 0x00000001,
    
	QCAP_FONT_STYLE_ITALIC      = 0x00000002,
    
	QCAP_FONT_STYLE_BOLDITALIC  = 0x00000003,
    
	QCAP_FONT_STYLE_UNDERLINE   = 0x00000004,
    
	QCAP_FONT_STYLE_STRIKEOUT   = 0x00000008,
};

// OSD STRING ALIGNMENT (OSD PROPERTY)
//
enum {

	QCAP_STRING_ALIGNMENT_STYLE_LEFT    = 0x00000000,

    QCAP_STRING_ALIGNMENT_STYLE_NEAR    = 0x00000000,
    
	QCAP_STRING_ALIGNMENT_STYLE_CENTER  = 0x00000001,
    
	QCAP_STRING_ALIGNMENT_STYLE_RIGHT   = 0x00000002,
    
	QCAP_STRING_ALIGNMENT_STYLE_FAR		= 0x00000002,
};

// OSD SEQUENCE STYLE (OSD PROPERTY)
//
enum {

	//  GENERAL DEVICE: FOREMOST -> PREVIEW CALLBACK -> BEFORE_ENCODE -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE RECORDING: FOREMOST -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE STREAMING: FOREMOST -> STREAMING (ENCODING) -> AFTERMOST
	//
	//  VIRTUAL CAMERA: FOREMOST -> AFTERMOST -> SHARING
	//
	//   FILE PLAYBACK: PLAYBACK (DECODING) -> FOREMOST -> DECODER CALLBACK -> AFTERMOST
	//
	QCAP_SEQUENCE_STYLE_FOREMOST		= 0x00000000,

    QCAP_SEQUENCE_STYLE_BEFORE_ENCODE	= 0x00000001, // IT IS ONLY USED FOR GENERAL DEVICE
    
	QCAP_SEQUENCE_STYLE_AFTERMOST		= 0x00000002,
};

// BUFFER SCALE STYLE (BUFFER PROPERTY)
//
enum {

	QCAP_SCALE_STYLE_STRETCH	= 0x00000000,

    QCAP_SCALE_STYLE_FIT		= 0x00000001,
    
	QCAP_SCALE_STYLE_FILL		= 0x00000002,
};

// DECODER TYPE (PLAYBACK PROPERTY)
//
enum {

	QCAP_DECODER_TYPE_SOFTWARE			= 0,

	QCAP_DECODER_TYPE_HARDWARE			= 1, // DEVELOPING ...

	QCAP_DECODER_TYPE_INTEL_MEDIA_SDK	= 2,

	QCAP_DECODER_TYPE_AMD_UVD			= 3, // DEVELOPING ...

	QCAP_DECODER_TYPE_AMD_VCE			= 3, // == QCAP_DECODER_TYPE_AMD_UVD

	QCAP_DECODER_TYPE_NVIDIA_CUDA		= 4,

	QCAP_DECODER_TYPE_NVIDIA_NVDEC		= 5,

	QCAP_DECODER_TYPE_NVIDIA_NVENC		= 5, // == QCAP_DECODER_TYPE_NVIDIA_NVDEC
};

// DECODER VIDEO FORMAT (PLAYBACK PROPERTY)
//
enum {

	QCAP_DECODER_FORMAT_MPEG2		=  1,

	QCAP_DECODER_FORMAT_H264		=  0,

	QCAP_DECODER_FORMAT_H264_3D		=  2, // H264 MVC (STEREOSCOPIC 3D)

	QCAP_DECODER_FORMAT_H264_VC		=  3, // H264 SVC (MULTIPLE TEMPORAL SCALABILITY)

	QCAP_DECODER_FORMAT_RAW			=  4,

	QCAP_DECODER_FORMAT_H265		=  5,
};

// 3D STEREO BUFFER TYPE
//
enum {

	QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE		= 0,

	QCAP_3D_STEREO_BUFFER_TOP_BOTTOM		= 1,

	QCAP_3D_STEREO_BUFFER_LINE_BY_LINE		= 2,
};

// 3D STEREO DISPLAY MODE
//
enum {

	QCAP_3D_STEREO_DISPLAY_MODE_SIDE_BY_SIDE	= 0,

	QCAP_3D_STEREO_DISPLAY_MODE_TOP_BOTTOM		= 1,

	QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE	= 2,

	QCAP_3D_STEREO_DISPLAY_MODE_LEFT_ONLY		= 3,

	QCAP_3D_STEREO_DISPLAY_MODE_RIGHT_ONLY		= 4,
};

// FILE TIMEUNIT
//
enum {

	QCAP_FILE_TIMEUNIT_TIME		= 0,

	QCAP_FILE_TIMEUNIT_FRAME	= 1,
};

// SERIAL PORT PARITY CHECK (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_PARITY_CHECK_NONE	= 0x00000000,

	QCAP_SERIAL_PORT_PARITY_CHECK_ODD	= 0x00000001,

	QCAP_SERIAL_PORT_PARITY_CHECK_EVEN	= 0x00000002,

	QCAP_SERIAL_PORT_PARITY_CHECK_MARK	= 0x00000003,		

	QCAP_SERIAL_PORT_PARITY_CHECK_SPACE	= 0x00000004,
};

// SERIAL PORT FLOW CONTROL (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_FLOW_CONTROL_NONE		= 0x00000000,

	QCAP_SERIAL_PORT_FLOW_CONTROL_CTS_RTS	= 0x00000001,

	QCAP_SERIAL_PORT_FLOW_CONTROL_CTS_DTR	= 0x00000002,

	QCAP_SERIAL_PORT_FLOW_CONTROL_DSR_RTS	= 0x00000003,

	QCAP_SERIAL_PORT_FLOW_CONTROL_DSR_DTR	= 0x00000004,

	QCAP_SERIAL_PORT_FLOW_CONTROL_XON_XOFF	= 0x00000005,
};

// SERIAL PORT STOP BITS (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_STOP_BITS_ONE				= 0x00000000,

	QCAP_SERIAL_PORT_STOP_BITS_ONE_POINT_FIVE	= 0x00000001,

	QCAP_SERIAL_PORT_STOP_BITS_TWO				= 0x00000002,
};

// SERIAL PORT SIGNAL TYPE (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_DTR		= 0x00000000, // CLEAR THE DTR (DATA-TERMINAL-READY) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_RTS		= 0x00000001, // CLEAR THE RTS (REQUEST-TO-SEND) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_DTR		= 0x00000002, // SEND THE DTR (DATA-TERMINAL-READY) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_RTS		= 0x00000003, // SEND THE RTS (REQUEST-TO-SEND) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_XOFF		= 0x00000004, // CAUSE TRANSMISSION TO ACT AS IF AN XOFF CHARACTER HAS BEEN RECEIVED

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_XON		= 0x00000005, // CAUSE TRANSMISSION TO ACT AS IF AN XON CHARACTER HAS BEEN RECEIVED

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_BREAK		= 0x00000006, // SUSPEND CHARACTER TRANSMISSION FOR A SPECIFIED COMMUNICATIONS DEVICE AND PLACES THE TRANSMISSION LINE IN A BREAK STATE UNTIL THE CLEARCOMMBREAK FUNCTION IS CALLED

	QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_BREAK	= 0x00000007, // RESTORE CHARACTER TRANSMISSION FOR A SPECIFIED COMMUNICATIONS DEVICE AND PLACES THE TRANSMISSION LINE IN A NONBREAK STATE
};

// CALLBACK FUNCTION TYPES //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef QRETURN (QCAP_EXPORT *PF_NO_SIGNAL_DETECTED_CALLBACK)( PVOID pDevice , ULONG nVideoInput , ULONG nAudioInput , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SIGNAL_REMOVED_CALLBACK)( PVOID pDevice , ULONG nVideoInput , ULONG nAudioInput , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FORMAT_CHANGED_CALLBACK)( PVOID pDevice , ULONG nVideoInput , ULONG nAudioInput , ULONG nVideoWidth , ULONG nVideoHeight , BOOL bVideoIsInterleaved , double dVideoFrameRate ,\
 ULONG nAudioChannels , ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FORMAT_CHANGED_CALLBACK_EX)( PVOID pDevice , ULONG nVideoInput , ULONG nAudioInput , ULONG nVideoWidth , ULONG nVideoHeight , BOOL bVideoIsInterleaved , double dVideoNativeFrameRate ,\
 double dVideoGrabFrameRate , ULONG nAudioChannels , ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SNAPSHOT_DONE_CALLBACK)( PVOID pDevice , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SNAPSHOT_STREAM_CALLBACK)( PVOID pDevice , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_RECORD_DONE_CALLBACK)( PVOID pDevice , UINT iRecNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_RECORD_FAIL_CALLBACK)( PVOID pDevice , UINT iRecNum , CHAR * pszFilePathName , QRESULT nErrorStatus , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_DONE_CALLBACK)( UINT iRecNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_FAIL_CALLBACK)( UINT iRecNum , CHAR * pszFilePathName , QRESULT nErrorStatus , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK)( UINT iRecNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK)( UINT iRecNum , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK)( PVOID pDevice , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_PREVIEW_CALLBACK)( PVOID pDevice , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_PREVIEW_CALLBACK)( PVOID pDevice , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_HARDWARE_ENCODER_CALLBACK)( PVOID pDevice , UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_RECORD_CALLBACK)( PVOID pDevice , UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_RECORD_CALLBACK)( PVOID pDevice , UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_RECORD_CALLBACK)( PVOID pDevice , UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum , UINT iTrackNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum , UINT iTrackNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK)( UINT iRecNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK)( UINT iRecNum , double dSampleTime , double dDelayTime , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK)( UINT iRecNum , double dSampleTime , double dDelayTime , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , double dDelayTime , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , double dDelayTime , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK)( PVOID pClient , ULONG nTotalStreams , UINT iStreamNum , ULONG nStream_PID , ULONG nProgram_PID , ULONG nVideoWidth , ULONG nVideoHeight ,\
 BOOL bVideoIsInterleaved , double dVideoFrameRate , ULONG nAudioChannels , ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , UINT iSessionNum , ULONG nVideoWidth , ULONG nVideoHeight , BOOL bVideoIsInterleaved , double dVideoFrameRate , ULONG nAudioChannels ,\
 ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_FAIL_CALLBACK)( PVOID pClient , UINT iSessionNum , QRESULT nErrorStatus , DWORD nErrorCode , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , QRESULT nErrorStatus , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , UINT iChNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer , UINT iProNum , ULONG nEncoderFormat , ULONG nWidth , ULONG nHeight , ULONG nFrameRate , ULONG nRecordMode ,\
 ULONG nQuality , ULONG nBitRate , ULONG nGOP , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer , UINT iProNum , ULONG nEncoderFormat , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , ULONG nBitRate , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK)( PVOID pEmulator , ULONG nTotalServers , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , ULONG nTotalVideoSources , ULONG nTotalAudioSources , ULONG nTotalVideoEncoders , ULONG nTotalAudioEncoders , ULONG nTotalProfiles ,\
 CHAR * pszName , CHAR * pszLocationr , CHAR * pszManufacturer , CHAR * pszModel , CHAR * pszHardwareVersion , CHAR * pszFirmwareVersion , CHAR * pszDeviceID , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGIN_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszPeerUserName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK)( PVOID pChatter , ULONG nPeerID , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszType , CHAR * pszSDP , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_CONNECTED_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nConnectionStatus , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_DISCONNECTED_CALLBACK)( PVOID pChatter , ULONG nPeerID , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , UINT iFrameNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , UINT iFrameNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile , UINT iChNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FILE_TRANSCODER_CALLBACK)( PVOID pFileTranscoder , double dPercentageCompleted , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK)( PVOID pPort , UINT iPortNum , BYTE * pDataBuffer , ULONG nDataBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_TIMER_CALLBACK)( PVOID pTimer , double dSampleTime , double dDelayTime , PVOID pUserData  );

// CALLBACK FUNCTIONS PART.I (EVENT) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK)( PVOID pDevice , PF_NO_SIGNAL_DETECTED_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK)( PVOID pDevice , PF_SIGNAL_REMOVED_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_FORMAT_CHANGED_CALLBACK)( PVOID pDevice , PF_FORMAT_CHANGED_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX)( PVOID pDevice , PF_FORMAT_CHANGED_CALLBACK_EX pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK)( PVOID pDevice , PF_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_RECORD_DONE_CALLBACK)( PVOID pDevice , UINT iRecNum , PF_RECORD_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_RECORD_FAIL_CALLBACK)( PVOID pDevice , UINT iRecNum , PF_RECORD_FAIL_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK)( UINT iRecNum , PF_SHARE_RECORD_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK)( UINT iRecNum , PF_SHARE_RECORD_FAIL_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK)( UINT iRecNum , PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );

// CALLBACK FUNCTIONS PART.II (DATA) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK)( PVOID pDevice , PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK)( PVOID pDevice , PF_VIDEO_PREVIEW_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK)( PVOID pDevice , PF_AUDIO_PREVIEW_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK)( PVOID pDevice , UINT iRecNum , PF_VIDEO_HARDWARE_ENCODER_CALLBACK pCB , PVOID pUserData  );

// CALLBACK FUNCTIONS PART.III (DATA) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK)( PVOID pDevice , PF_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK)( UINT iRecNum , PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );

// CALLBACK FUNCTIONS PART.IIII (DATA) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_RECORD_CALLBACK)( PVOID pDevice , UINT iRecNum , PF_VIDEO_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_RECORD_CALLBACK)( PVOID pDevice , UINT iRecNum , PF_AUDIO_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_MEDIA_RECORD_CALLBACK)( PVOID pDevice , UINT iRecNum , PF_MEDIA_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_VIDEO_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_AUDIO_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_AUDIO_MX_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_MEDIA_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK)( UINT iRecNum , PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK)( UINT iRecNum , PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK)( UINT iRecNum , PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_VIDEO_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_AUDIO_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_AUDIO_MX_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer , UINT iSessionNum , PF_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK)( PVOID pClient , ULONG nTotalStreams , UINT iStreamNum , ULONG nStream_PID , ULONG nProgram_PID , ULONG nVideoWidth , ULONG nVideoHeight ,\
 BOOL bVideoIsInterleaved , double dVideoFrameRate , ULONG nAudioChannels , ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , UINT iSessionNum , ULONG nVideoWidth , ULONG nVideoHeight , BOOL bVideoIsInterleaved , double dVideoFrameRate , ULONG nAudioChannels ,\
 ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_FAIL_CALLBACK)( PVOID pClient , UINT iSessionNum , QRESULT nErrorStatus , DWORD nErrorCode , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , QRESULT nErrorStatus , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , UINT iChNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_CONNECTED_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_FAIL_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient , PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , PF_VIDEO_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , PF_AUDIO_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer , UINT iProNum , ULONG nEncoderFormat , ULONG nWidth , ULONG nHeight , ULONG nFrameRate , ULONG nRecordMode ,\
 ULONG nQuality , ULONG nBitRate , ULONG nGOP , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer , UINT iProNum , ULONG nEncoderFormat , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , ULONG nBitRate , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer , PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer , PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK)( PVOID pEmulator , ULONG nTotalServers , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK)( PVOID pEmulator , PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , ULONG nTotalVideoSources , ULONG nTotalAudioSources , ULONG nTotalVideoEncoders , ULONG nTotalAudioEncoders , ULONG nTotalProfiles ,\
 CHAR * pszName , CHAR * pszLocationr , CHAR * pszManufacturer , CHAR * pszModel , CHAR * pszHardwareVersion , CHAR * pszFirmwareVersion , CHAR * pszDeviceID , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGIN_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszPeerUserName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK)( PVOID pChatter , ULONG nPeerID , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszType , CHAR * pszSDP , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_CONNECTED_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nConnectionStatus , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_DISCONNECTED_CALLBACK)( PVOID pChatter , ULONG nPeerID , PVOID pUserData  );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_SEND_DATA_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nSendStatus , PVOID pUserData  );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_SEND_FILE_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nSendStatus , PVOID pUserData  );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_DATA_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszData , ULONG nDataSize , PVOID pUserData  );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_FILE_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszFileNamePath , PVOID pUserData  );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK)( PVOID pChatter , ULONG nPeerID , ULONG nRecvSize , ULONG nTotalSize , PVOID pUserData  );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_NETWORK_QOS_STATUS_CALLBACK)( PVOID pChatter , ULONG nExpectedBitRate , ULONG nExpectedFrameRate , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK)( PVOID pChatter , PF_WEBRTC_CHATROOM_LOGIN_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK)( PVOID pChatter , PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK)( PVOID pChatter , PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK)( PVOID pChatter , PF_WEBRTC_PEER_CONNECTED_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK)( PVOID pChatter , PF_WEBRTC_PEER_DISCONNECTED_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK)( PVOID pChatter , PF_WEBRTC_SEND_DATA_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK)( PVOID pChatter , PF_WEBRTC_SEND_FILE_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK)( PVOID pChatter , PF_WEBRTC_RECEIVED_DATA_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK)( PVOID pChatter , PF_WEBRTC_RECEIVED_FILE_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK)( PVOID pChatter , PF_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK)( PVOID pChatter , PF_WEBRTC_NETWORK_QOS_STATUS_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , UINT iFrameNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , UINT iFrameNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile , UINT iChNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile , PF_FILE_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile , PF_FILE_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile , PF_VIDEO_DECODER_FILE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile , PF_AUDIO_DECODER_FILE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , PF_VIDEO_DECODER_FILE_CALLBACK_EX pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , PF_AUDIO_DECODER_FILE_CALLBACK_EX pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile , PF_VIDEO_DECODER_3D_FILE_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_FILE_TRANSCODER_CALLBACK)( PVOID pFileTranscoder , double dPercentageCompleted , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_FILE_TRANSCODER_CALLBACK)( PVOID pFileTranscoder , PF_FILE_TRANSCODER_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera , CHAR * pszFilePathName , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera , PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera , PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK)( PVOID pPort , UINT iPortNum , BYTE * pDataBuffer , ULONG nDataBufferLen , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK)( PVOID pPort , PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK pCB , PVOID pUserData  );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_TIMER_CALLBACK)( PVOID pTimer , double dSampleTime , double dDelayTime , PVOID pUserData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_MEDIA_TIMER_CALLBACK)( PVOID pTimer , PF_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );

// SYSTEM FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VERSION)( ULONG * pMajorVersion , ULONG * pMinorVersion  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_SYSTEM_CONFIGURATION)( BOOL   bEnableMultipleUsersAccess = TRUE,					  // If true, qcap will alllow multiple users to access the device.

															    BOOL   bEnableVideoPreviewDevice = TRUE,					  // If true, the video capture device will be enabled.

															    BOOL   bEnableAudioPreviewDevice = TRUE,					  // If true, the audio capture device will be enabled.

															    BOOL   bEnableVideoHardwareMainEncoderDevice = TRUE,		  // If true, the main hardware encoder will be enabled.

															    BOOL   bEnableVideoHardwareSubEncoderDevice = TRUE,			  // If true, the sub hardware encoder will be enabled.

															    ULONG  nAutoInputDetectionTimeout = 3000,					  // The parameter allows you to specify the timeout duration of the auto input detection, default is 3sec.

															    BOOL   bEnableSCF = FALSE,									  // If true, the SCF file recording function will be turned on.
															   
															    CHAR * pszDB3 = NULL,										  // The parameter allows you to specify the file path of SQL database.
															   
															    BOOL   bEnableAsyncBackgroundSnapshot = FALSE,				  // If true, snapshot function will be moved from preview callback into another thread. 
															   
															    BOOL   bEnableEnhancedVideoRenderer = TRUE,					  // If true, QCAP will enable the DirectShow's Enhanced Video Renderer Filter.
															   
															    BOOL   bEnableSystemTimeCallback = FALSE,					  // If true, the preview's and encoder's callbacks will return one local system time at dSampleTime.
															   
															    BOOL   bEnableFileRepairFunction = TRUE,					  // If true, the recording file will own self-repaired ability.
															   
															    BOOL   bEnableNewRTSPLibrary = TRUE,						  // If true, we will use new rtsp lib to repalce old one after 1.1.0.130.0
																
																CHAR * pszWebServerRootFolderPath = NULL,					  // The parameter allows you to specify the web server's root folder path.

																CHAR * pszWebServerIP = NULL,								  // The parameter allows you to specify the web server's ip address.
																
																ULONG  nSystemColorRangeType = QCAP_COLORRANGE_TYPE_FULL,     // The parameter allows you to specify the system color range setting.
																
																BOOL   bEnableVideoMixingRendererBugPatch = TRUE,             // If true, QCAP will enable the bug patch for DirectShow's Video Mixing Renderer, but it will delay the device's initialized time.
																
																BOOL   bEnableDirect3DVideoRenderer = FALSE );                // If true, QCAP will enable the Direct3D's Video Renderer Filter.

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_ENCODER_TYPE_CAP)( ULONG nEncoderType , ULONG nEncoderFormat  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_DECODER_TYPE_CAP)( ULONG nDecoderType , ULONG nDecoderFormat  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_ENCODER_STATUS)( ULONG nEncoderType , ULONG * pExistInstances  );

// DEVICE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DEVICE_ENUMERATION)( ULONGLONG * * ppVideoDeviceList , ULONG * pVideoDeviceSize , ULONGLONG * * ppVideoEncoderDeviceList , ULONG * pVideoEncoderDeviceSize , ULONGLONG * * ppAudioDeviceList ,\
 ULONG * pAudioDeviceSize , ULONGLONG * * ppAudioEncoderDeviceList , ULONG * pAudioEncoderDeviceSize , ULONG nDeviceEnumType = QCAP_ENUM_TYPE_DEVICE_NAME  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO)( UINT iDevNum , ULONGLONG * pDeviceList , ULONG * pDeviceInfoH , ULONG * pDeviceInfoL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE)( CHAR * pszDevName , UINT iDevNum , HWND hAttachedWindow , PVOID * ppDevice , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE  );

// DEVICE NAME TABLE:
//
// "DC1150 USB" IS FOR PD652, PD652.3D
//
// "QP0204 USB" IS FOR PD5A0
//
// "UB658G USB" IS FOR UB658
//
// "CY3014 USB" IS FOR UB530
//
// "UB3200 USB" IS FOR PD560
//
// "UB3300 USB" IS FOR PD570
//
// "TW6802 PCI" IS FOR SC200, SC300, SC230, SC330
//
// "CX2581 PCI" IS FOR SC310, SC340
//
// "CX2385 PCI" IS FOR SC350
//
// "AH8400 PCI" IS FOR SC290, SC390
//
// "FH8735 PCI" IS FOR SC2A0, SC3A0
//
// "TW5864 PCI" IS FOR SC2B0, SC3B0
//
// "MZ0380 PCI" IS FOR SC3C0
//
// "SA7160 PCI" IS FOR SC500, SC510, TB510
//
// "FH8735 PCI" IS FOR SC580
//
// "TW2809 PCI" IS FOR SC590
//
// "QP0203 PCI" IS FOR SC540, SC5A0
//
// "MZ0380 PCI" IS FOR SC350, SC3C0, SC550, SC560, SC5C0
//
//     "CAMERA" IS FOR GENERAL USB CAMERA
//
//  "SOUNDCARD" IS FOR GENERAL SOUND CARD
//
//    "DESKTOP" IS FOR GENERAL DESKTOP SCREEN GRABBER

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY)( PVOID pDevice  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RUN)( PVOID pDevice  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RUN_EX)( PVOID pDevice , BOOL bStopAfterSignalRemoved = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP)( PVOID pDevice  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_DEVICE_CAP)( PVOID pDevice , DWORD * pDeviceSerialNumber , CHAR * pszDeviceSystemPath , BOOL * pHasHardwareMainEncoder , BOOL * pHasHardwareSubEncoder  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_INPUT)( PVOID pDevice , ULONG * pInput  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_INPUT)( PVOID pDevice , ULONG nInput  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_INPUT)( PVOID pDevice , ULONG * pInput  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_INPUT)( PVOID pDevice , ULONG nInput  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_STANDARD)( PVOID pDevice , ULONG * pStandard  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_STANDARD)( PVOID pDevice , ULONG nStandard  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS)( PVOID pDevice , ULONG * pStatus  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT)( PVOID pDevice , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight , BOOL * pIsInterleaved , double * pFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT_EX)( PVOID pDevice , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight , BOOL * pIsInterleaved , double * pNativeFrameRate , double * pGrabFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT)( PVOID pDevice , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight , BOOL * pIsInterleaved , double * pFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BOOL bIsInterleaved , double dFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES)( PVOID pDevice , ULONG * pLines  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES)( PVOID pDevice , ULONG nLines  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_DEINTERLACE_TYPE)( PVOID pDevice , ULONG * pType  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_DEINTERLACE_TYPE)( PVOID pDevice , ULONG nType  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_DEINTERLACE)( PVOID pDevice , BOOL * pEnable  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_DEINTERLACE)( PVOID pDevice , BOOL bEnable  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_REGION_DISPLAY)( PVOID pDevice , ULONG * pCropX , ULONG * pCropY , ULONG * pCropW , ULONG * pCropH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_REGION_DISPLAY)( PVOID pDevice , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_MIRROR)( PVOID pDevice , BOOL * pHorizontalMirror , BOOL * pVerticalMirror  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_MIRROR)( PVOID pDevice , BOOL bHorizontalMirror , BOOL bVerticalMirror  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BRIGHTNESS)( PVOID pDevice , ULONG * pValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BRIGHTNESS)( PVOID pDevice , ULONG nValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CONTRAST)( PVOID pDevice , ULONG * pValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_CONTRAST)( PVOID pDevice , ULONG nValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HUE)( PVOID pDevice , ULONG * pValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HUE)( PVOID pDevice , ULONG nValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SATURATION)( PVOID pDevice , ULONG * pValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SATURATION)( PVOID pDevice , ULONG nValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARPNESS)( PVOID pDevice , ULONG * pValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARPNESS)( PVOID pDevice , ULONG nValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BRIGHTNESS_EX)( PVOID pDevice , ULONG * pPhysicalValue  , ULONG * pDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BRIGHTNESS_EX)( PVOID pDevice , ULONG nPhysicalValue  , ULONG nDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CONTRAST_EX)( PVOID pDevice , ULONG * pPhysicalValue  , ULONG * pDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_CONTRAST_EX)( PVOID pDevice , ULONG nPhysicalValue  , ULONG nDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HUE_EX)( PVOID pDevice , ULONG * pPhysicalValue  , ULONG * pDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HUE_EX)( PVOID pDevice , ULONG nPhysicalValue  , ULONG nDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SATURATION_EX)( PVOID pDevice , ULONG * pPhysicalValue  , ULONG * pDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SATURATION_EX)( PVOID pDevice , ULONG nPhysicalValue  , ULONG nDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARPNESS_EX)( PVOID pDevice , ULONG * pPhysicalValue  , ULONG * pDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARPNESS_EX)( PVOID pDevice , ULONG nPhysicalValue  , ULONG nDisplayValue   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX)( PVOID pDevice , ULONG * pDownscaleMode  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX)( PVOID pDevice , ULONG nDownscaleMode  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG * pEncoderFormat , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP ,\
 ULONG * pAspectRatioX , ULONG * pAspectRatioY , ULONG * pDownscaleMode , ULONG * pPostSkipFrameRate  , ULONG * pPostAvgFrameRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG   nEncoderFormat ,  ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,\
  ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  ULONG   nDownscaleMode ,  ULONG   nPostSkipFrameRate   , ULONG   nPostAvgFrameRate    );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG * pEncoderFormat , ULONG * pRecordProfile , ULONG * pRecordLevel , ULONG * pRecordEntropy ,\
 ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pBFrames , BOOL * pIsInterleaved , ULONG * pSlices , ULONG * pLayers , ULONG * pSceneCut , BOOL * pMultiThread , BOOL * pMBBRC , BOOL * pExtBRC , ULONG * pMinQP  ,\
 ULONG * pMaxQP  , ULONG * pVBVMaxRate  , ULONG * pVBVBufSize  , ULONG * pCBRVariation  , ULONG * pAspectRatioX , ULONG * pAspectRatioY , ULONG * pCropX , ULONG * pCropY , ULONG * pCropW , ULONG * pCropH , ULONG * pDstW , ULONG * pDstH , ULONG * pPostSkipFrameRate  ,\
 ULONG * pPostAvgFrameRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG   nEncoderFormat ,  ULONG   nRecordProfile  , ULONG   nRecordLevel  , ULONG   nRecordEntropy  ,\
 ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nBFrames  , BOOL   bIsInterleaved  , ULONG   nSlices  , ULONG   nLayers  , ULONG   nSceneCut ,  BOOL   bMultiThread ,  BOOL   bMBBRC ,  BOOL   bExtBRC ,\
  ULONG   nMinQP   , ULONG   nMaxQP   , ULONG   nVBVMaxRate   , ULONG   nVBVBufSize   , ULONG   nCBRVariation   , ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  ULONG   nCropX ,  ULONG   nCropY ,  ULONG   nCropW ,  ULONG   nCropH ,  ULONG   nDstW ,\
  ULONG   nDstH ,  ULONG   nPostSkipFrameRate   , ULONG   nPostAvgFrameRate    );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG nProperty , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG nProperty , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SOUND_RENDERER)( PVOID pDevice , UINT * pSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SOUND_RENDERER)( PVOID pDevice , UINT iSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_VOLUME)( PVOID pDevice , ULONG * pVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_VOLUME)( PVOID pDevice , ULONG nVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DEVICE_CUSTOM_PROPERTY)( PVOID pDevice , ULONG nProperty , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEVICE_CUSTOM_PROPERTY)( PVOID pDevice , ULONG nProperty , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX)( PVOID pDevice , ULONG nProperty , BYTE * pValue , ULONG nBytes  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX)( PVOID pDevice , ULONG nProperty , BYTE * pValue , ULONG nBytes  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DIAGNOSE_VIDEO_STREAM_STATUS)( PVOID pDevice , BOOL * pIsStill , ULONG nStillThreshold = 64  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DIAGNOSE_AUDIO_STREAM_STATUS)( PVOID pDevice , double * pVolumeDB_L  , double * pVolumeDB_R   );

////

////

////

////

////

////

////

////

// LOCK/UNLOCK FUNCTIONS (FOR LABVIEW 2010/2012 DEVELOPER) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COPY_VIDEO_PREVIEW_BUFFER)( PVOID pDevice , double * pSampleTime , ULONG nColorSpaceType , VOID * pFrameBuffer , ULONG * pFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COPY_AUDIO_PREVIEW_BUFFER)( PVOID pDevice , double * pSampleTime , VOID * pFrameBuffer , ULONG * pFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOCK_VIDEO_PREVIEW_BUFFER)( PVOID pDevice , double * pSampleTime , VOID * * ppFrameBuffer , ULONG * pFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER)( PVOID pDevice  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOCK_AUDIO_PREVIEW_BUFFER)( PVOID pDevice , double * pSampleTime , VOID * * ppFrameBuffer , ULONG * pFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER)( PVOID pDevice  );

// SNAPSHOT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BMP)( PVOID pDevice , CHAR * pszFilePathName , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_JPG)( PVOID pDevice , CHAR * pszFilePathName , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BMP_EX)( PVOID pDevice , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_JPG_EX)( PVOID pDevice , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH , ULONG nQuality ,\
 BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

////

////

// CHANNEL RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS CHANNEL RECORDING) (RECNUM: 0 ~ 3) /////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_RECORD_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate ,\
 ULONG * pGOP , ULONG * pAspectRatioX , ULONG * pAspectRatioY , ULONG * pDownscaleMode  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_RECORD_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,\
  ULONG   nGOP ,  ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  ULONG   nDownscaleMode   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_RECORD_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pRecordProfile  , ULONG * pRecordLevel  , ULONG * pRecordEntropy  ,\
 ULONG * pRecordComplexity  , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pBFrames  , BOOL * pIsInterleaved  , ULONG * pSlices  , ULONG * pLayers  , ULONG * pSceneCut  , BOOL * pMultiThread  ,\
 BOOL * pMBBRC  , BOOL * pExtBRC  , ULONG * pMinQP  , ULONG * pMaxQP  , ULONG * pVBVMaxRate  , ULONG * pVBVBufSize  , ULONG * pCBRVariation  , ULONG * pAspectRatioX , ULONG * pAspectRatioY , ULONG * pCropX , ULONG * pCropY , ULONG * pCropW ,\
 ULONG * pCropH , ULONG * pDstW , ULONG * pDstH , ULONG * pPostSkipFrameRate  , ULONG * pPostAvgFrameRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_RECORD_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nRecordProfile   , ULONG   nRecordLevel   ,\
 ULONG   nRecordEntropy   , ULONG   nRecordComplexity   , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nBFrames   , BOOL   bIsInterleaved   , ULONG   nSlices   , ULONG   nLayers   , ULONG   nSceneCut   ,\
 BOOL   bMultiThread   , BOOL   bMBBRC   , BOOL   bExtBRC   , ULONG   nMinQP   , ULONG   nMaxQP   , ULONG   nVBVMaxRate   , ULONG   nVBVBufSize   , ULONG   nCBRVariation   , ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  ULONG   nCropX ,  ULONG   nCropY ,\
  ULONG   nCropW ,  ULONG   nCropH ,  ULONG   nDstW ,  ULONG   nDstH ,  ULONG   nPostSkipFrameRate   , ULONG   nPostAvgFrameRate    );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_RECORD_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_RECORD_PROPERTY)( PVOID pDevice , UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_RECORD_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pBitRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_RECORD_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nBitRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX)( PVOID pDevice , UINT iRecNum , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_METADATA_RECORD_HEADER)( PVOID pDevice , UINT iRecNum , CHAR * pszTitle , CHAR * pszArtist , CHAR * pszComments , CHAR * pszGenre , CHAR * pszComposer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_METADATA_RECORD_HEADER_W)( PVOID pDevice , UINT iRecNum , WSTRING pwszTitle , WSTRING pwszArtist , WSTRING pwszComments , WSTRING pwszGenre , WSTRING pwszComposer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_METADATA_RECORD_DATA_BUFFER)( PVOID pDevice , UINT iRecNum , BYTE * pDataBuffer , ULONG nDataBufferSize , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_CLONE_RECORD)( PVOID pDevice , UINT iRecNum , CHAR * pszFilePathNameA , CHAR * pszFilePathNameB , DWORD dwFlags = QCAP_RECORD_FLAG_FULL , double dVideoDelayTime = 0.0 ,\
 double dAudioDelayTime = 0.0 , double dSegmentDurationTime = 0.0 , ULONG nSegmentDurationSizeKB = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_TIMESHIFT_RECORD)( PVOID pDevice , UINT iRecNum , CHAR * pszFilePathName , PVOID * ppPhysicalFileWriter , DWORD dwFlags = QCAP_RECORD_FLAG_FULL , double dVideoDelayTime = 0.0 ,\
 double dAudioDelayTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_FAILSAFE_RECORD)( PVOID pDevice , UINT iRecNum , CHAR * pszFilePathName , UINT iLinkRecNum , PVOID pLinkPhysicalFileWriter , double dPreRecordTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_RECORD)( PVOID pDevice , UINT iRecNum , CHAR * pszFilePathName , DWORD dwFlags = QCAP_RECORD_FLAG_FULL , double dVideoDelayTime = 0.0 , double dAudioDelayTime = 0.0 ,\
 double dSegmentDurationTime = 0.0 , ULONG nSegmentDurationSizeKB = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_RECORD)( PVOID pDevice , UINT iRecNum , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_RECORD)( PVOID pDevice , UINT iRecNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_RECORD)( PVOID pDevice , UINT iRecNum  );

////

////

////

////

////

// CLONE FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_CLONE)( PVOID pDevice , HWND hAttachedWindow , PVOID * ppCloneDevice , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE  );

// OSD FUNCTIONS (SUPPORT MULTIPLE-LAYERS OSD OBJECTS) (OSDNUM: 0 ~ 511) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MOVE_OSD_OBJECT)( PVOID pDevice , UINT iOsdNum , INT x , INT y , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_TEXT_BOUNDARY)( PVOID pDevice , UINT iOsdNum , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_TEXT_BOUNDARY_W)( PVOID pDevice , UINT iOsdNum , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_TEXT)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_TEXT_W)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_TEXT_EX)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_TEXT_EX_W)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_PICTURE)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszFilePathName , ULONG nTransparent , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BUFFER)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth , ULONG nFrameHeight ,\
 ULONG nFramePitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BUFFER_EX)( PVOID pDevice , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth , ULONG nFrameHeight ,\
 ULONG nFramePitch , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  ,\
 BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

// MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) //////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_SYNCHRONIZED_RECORD)( PVOID * ppSyncRecorder , ULONG nFileArgs , CHAR * pszFilePathName1 , PVOID pDevice1 , UINT iRecNum1 , CHAR * pszFilePathName2 , PVOID pDevice2 , UINT iRecNum2 , ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_SYNCHRONIZED_RECORD)( PVOID pSyncRecorder  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_SYNCHRONIZED_RECORD)( PVOID pSyncRecorder  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_SYNCHRONIZED_RECORD)( PVOID pSyncRecorder , BOOL bIsAsync , ULONG nMilliseconds  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_SYNCHRONIZED_RECORD)( PVOID pSyncRecorder );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_SYNCHRONIZED_RECORD)( PVOID pSyncRecorder );

// SYNCHRONIZED RECORDING EXAMPLE
//
// QCAP_CREATE_SYNCHRONIZED_RECORD( &pSyncRecorder, 4, "SR_CH01.MP4", pDevices[ 0 ], 0, 
//
//								                       "SR_CH02.MP4", pDevices[ 1 ], 0, 
//
//								                       "SR_CH03.MP4", pDevices[ 2 ], 0, 
//
//								                       "SR_CH04.MP4", pDevices[ 3 ], 0 );
//
// QCAP_START_SYNCHRONIZED_RECORD( pSyncRecorder );
// 
// QCAP_STOP_SYNCHRONIZED_RECORD( pSyncRecorder, TRUE, 0 );
// 
// QCAP_DESTROY_SYNCHRONIZED_RECORD( pSyncRecorder );
// 
// CAMERA FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CAMERA_ENUMERATION)( CHAR * * ppszCameraDevName , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CAMERA_ENUMERATION_W)( WSTRING * ppwszCameraDevName , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEFAULT_CAMERA)( CHAR * pszCameraDevName  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_CAMERA_COUNT_OF_SUPPORT_OUTPUT_FORMATS)( PVOID pDevice , ULONG * pCount  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_CAMERA_SUPPORT_OUTPUT_FORMAT)( PVOID pDevice , UINT iFmtNum , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight , BOOL * pIsInterleaved , double * pFrameRate  );

// CAMERA EXAMPLE:
// 
// STEP#01 QCAP_CREATE( "CAMERA", 0, hWindow, &pDevice, TRUE );
// 
// STEP#03 QCAP_RUN( pDevice );
// 
// STEP#04 QCAP_STOP( pDevice );
// 
// STEP#05 QCAP_DESTROY( pDevice );

// SOUNCARD FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SOUNDCARD_ENUMERATION)( CHAR * * ppszSoundCardDevName , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SOUNDCARD_ENUMERATION_W)( WSTRING * ppwszSoundCardDevName , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEFAULT_SOUNDCARD)( CHAR * pszMicrophoneDevName , CHAR * pszLineInDevName  );

// SOUNCARD EXAMPLE:
// 
// STEP#01 QCAP_CREATE( "SOUNDCARD", 0, hWindow, &pDevice, TRUE );
// 
// STEP#02 QCAP_SET_AUDIO_INPUT( pDevice, QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN );
// 
// STEP#03 QCAP_RUN( pDevice );
// 
// STEP#04 QCAP_STOP( pDevice );
// 
// STEP#05 QCAP_DESTROY( pDevice );

// SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_SHARE_RECORD_STATUS)( UINT iRecNum , BOOL * pIsValid  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY)( UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight , double * pFrameRate ,\
 ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pAspectRatioX , ULONG * pAspectRatioY , HWND * pAttachedWindow = NULL , BOOL * pThumbDraw = NULL , BOOL * pMaintainAspectRatio = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY)( UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nColorSpaceType ,  ULONG   nWidth ,  ULONG   nHeight ,\
  double   dFrameRate ,  ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  HWND   hAttachedWindow = NULL ,  BOOL   bThumbDraw = FALSE , BOOL   bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight ,\
 double * pFrameRate , ULONG * pRecordProfile  , ULONG * pRecordLevel  , ULONG * pRecordEntropy  , ULONG * pRecordComplexity  , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pBFrames  , BOOL * pIsInterleaved  , ULONG * pSlices  ,\
 ULONG * pLayers  , ULONG * pSceneCut  , BOOL * pMultiThread  , BOOL * pMBBRC  , BOOL * pExtBRC  , ULONG * pMinQP  , ULONG * pMaxQP  , ULONG * pVBVMaxRate  , ULONG * pVBVBufSize  , ULONG * pCBRVariation  , ULONG * pAspectRatioX , ULONG * pAspectRatioY ,\
 HWND * pAttachedWindow = NULL , BOOL * pThumbDraw = NULL , BOOL * pMaintainAspectRatio = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nColorSpaceType ,  ULONG   nWidth ,  ULONG   nHeight ,\
  double   dFrameRate ,  ULONG   nRecordProfile   , ULONG   nRecordLevel   , ULONG   nRecordEntropy   , ULONG   nRecordComplexity   , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nBFrames   , BOOL   bIsInterleaved   ,\
 ULONG   nSlices   , ULONG   nLayers   , ULONG   nSceneCut   , BOOL   bMultiThread   , BOOL   bMBBRC   , BOOL   bExtBRC   , ULONG   nMinQP   , ULONG   nMaxQP   , ULONG   nVBVMaxRate   , ULONG   nVBVBufSize   , ULONG   nCBRVariation   ,\
 ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  HWND   hAttachedWindow = NULL ,  BOOL   bThumbDraw = FALSE , BOOL   bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX)( UINT iRecNum , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX)( UINT iRecNum , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_COPP)( UINT iRecNum , BOOL * pEnable  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_COPP)( UINT iRecNum , BOOL   bEnable   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_BRIGHTNESS)( UINT iRecNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_BRIGHTNESS)( UINT iRecNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_CONTRAST)( UINT iRecNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_CONTRAST)( UINT iRecNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_HUE)( UINT iRecNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_HUE)( UINT iRecNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_SATURATION)( UINT iRecNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_SATURATION)( UINT iRecNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY)( UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY)( UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency , ULONG * pBitRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency ,  ULONG   nBitRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SHARE_RECORD_SOUND_RENDERER)( UINT iRecNum , UINT * pSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_SOUND_RENDERER)( UINT iRecNum , UINT   iSoundNum   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SHARE_RECORD_VOLUME)( UINT iRecNum , ULONG * pVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_VOLUME)( UINT iRecNum , ULONG   nVolume   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH , BOOL bForceKeyFrame = FALSE , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER)( UINT iRecNum , BYTE * pStreamBuffer , ULONG nStreamBufferLen , ULONG bIsKeyFrame , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER)( UINT iRecNum , BYTE * pStreamBuffer , ULONG nStreamBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_METADATA_SHARE_RECORD_HEADER)( UINT iRecNum , CHAR * pszTitle , CHAR * pszArtist , CHAR * pszComments , CHAR * pszGenre , CHAR * pszComposer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_METADATA_SHARE_RECORD_HEADER_W)( UINT iRecNum , WSTRING pwszTitle , WSTRING pwszArtist , WSTRING pwszComments , WSTRING pwszGenre , WSTRING pwszComposer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_METADATA_SHARE_RECORD_DATA_BUFFER)( UINT iRecNum , BYTE * pDataBuffer , ULONG nDataBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_TIMESHIFT_SHARE_RECORD)( UINT iRecNum , CHAR * pszFilePathName , PVOID * ppPhysicalFileWriter , DWORD dwFlags = QCAP_RECORD_FLAG_FULL , double dVideoDelayTime = 0.0 , double dAudioDelayTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_SHARE_RECORD)( UINT iRecNum , CHAR * pszFilePathName , DWORD dwFlags = QCAP_RECORD_FLAG_FULL , double dVideoDelayTime = 0.0 , double dAudioDelayTime = 0.0 ,\
 double dSegmentDurationTime = 0.0 , ULONG nSegmentDurationSizeKB = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_SHARE_RECORD)( UINT iRecNum , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_SHARE_RECORD)( UINT iRecNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_SHARE_RECORD)( UINT iRecNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_BMP)( UINT iRecNum , CHAR * pszFilePathName , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_JPG)( UINT iRecNum , CHAR * pszFilePathName , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX)( UINT iRecNum , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX)( UINT iRecNum , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH , ULONG nQuality ,\
 BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MOVE_OSD_SHARE_RECORD_OBJECT)( UINT iRecNum , UINT iOsdNum , INT x , INT y , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY)( UINT iRecNum , UINT iOsdNum , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY_W)( UINT iRecNum , UINT iOsdNum , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_TEXT)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_TEXT_W)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_TEXT_EX)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_TEXT_EX_W)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_PICTURE)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszFilePathName , ULONG nTransparent , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_BUFFER)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth , ULONG nFrameHeight ,\
 ULONG nFramePitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_BUFFER_EX)( UINT iRecNum , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth ,\
 ULONG nFrameHeight , ULONG nFramePitch , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  ,\
 BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

////

////

////

////

////

////

////

////

////

////

////

////

////

// VIDEO 3D SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) ///////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH , ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum , ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE , BOOL bLeftRightSwap = FALSE ,\
 BOOL bForceKeyFrame = FALSE , double dSampleTime = 0.0  );

// AUDIO MIXING/TRACKS SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) (TRACKNUM: 0 ~ 3) //////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum , ULONG * pTracks , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample ,\
 ULONG * pSampleFrequency , ULONG * pBitRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum , ULONG   nTracks ,  ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,\
  ULONG   nSampleFrequency ,  ULONG   nBitRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER)( UINT iRecNum , UINT iTrackNum , UINT iMixNum , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum , UINT iTrackNum , UINT iMixNum , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency ,\
 BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum , UINT iTrackNum , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER)( UINT iRecNum , UINT iTrackNum , BYTE * pStreamBuffer , ULONG nStreamBufferLen , double dSampleTime = 0.0  );

////

////

// ##########################################################################################################################################################################################
// #
// # BROADCASTING SERVER FUNCTIONS (RTSP/RTMP/HLS/TS/MMS) (2D/3D)
// #
// ##########################################################################################################################################################################################
//












QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_BROADCAST_SERVER_STATUS)( UINT iSvrNum  , BOOL * pIsValid  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_RTSP_SERVER)( UINT iSvrNum  , ULONG nTotalSessions , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL , ULONG nNetworkPort_RTSP = 554 ,\
 ULONG nNetworkPort_RTSPOverHTTP = 0  , BOOL bEnableMulticasting = FALSE , BOOL bEnableUltraLowLatency = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_RTSP_RAW_UDP_SERVER)( UINT iSvrNum  , ULONG nTotalSessions , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL , ULONG nNetworkPort_RTSP = 554  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_HLS_SERVER)( UINT iSvrNum  , ULONG nTotalSessions , PVOID * ppServer , CHAR * pszWebServerRootFolderPath , CHAR * pszSubFolderPath , ULONG nSegmentDuration = 1000 ,\
 BOOL bResumeSegmentNum = FALSE , ULONG nSegmentPlaylistCount = 3 , CHAR * pszWebServerIP = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_RTMP_SERVER)( UINT iSvrNum  , ULONG nTotalSessions , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL , ULONG nNetworkPort_RTMP = 1935 ,\
 ULONG nNetworkPort_RTMPOverHTTP = 0  , CHAR * pszServerName = NULL  , CHAR * pszMediaFolderPath = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_RTMP_SERVER_EX)( UINT iSvrNum  , ULONG nTotalSessions , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL , ULONG nNetworkPort_RTMP = 1935 ,\
 ULONG nNetworkPort_RTMPOverHTTP = 0  , CHAR * pszServerName = NULL  , CHAR * pszMediaFolderPath = NULL , CHAR * pszEncryptKey = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER)( UINT iSvrNum  , CHAR * pszURL , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX)( UINT iSvrNum  , CHAR * pszURL , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL , CHAR * pszEncryptKey = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER)( UINT iSvrNum  , CHAR * pszURL , PVOID * ppServer , CHAR * pszAccount = NULL , CHAR * pszPassword = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER)( UINT iSvrNum  , CHAR * pszURL , PVOID * ppServer , CHAR * pszNetworkAdapterIP = NULL , ULONG nServiceID = 1 , CHAR * pszServiceName = NULL ,\
 CHAR * pszServiceProviderName = NULL , BOOL bEnableCBRMode = TRUE , ULONG nTransferBitRate = 0  , ULONG nOriginalNetworkID = 1 , ULONG nTransportStreamID = 1 , ULONG nPMT_PID = 4096 , ULONG nPCR_PID = 4097 , ULONG nVideo_PID = 256 ,\
 ULONG nAudio_PID = 257 , ULONG nVideo_CodecID = 0  , ULONG nAudio_CodecID = 0  , ULONG nPCRInterval = 0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_TS_OVER_TCP_SERVER)( UINT iSvrNum  , PVOID * ppServer , ULONG nNetworkPort_TCP = 1234 , CHAR * pszNetworkAdapterIP = NULL , ULONG nServiceID = 1 ,\
 CHAR * pszServiceName = NULL , CHAR * pszServiceProviderName = NULL , ULONG nTransferBitRate = 0  , ULONG nOriginalNetworkID = 1 , ULONG nTransportStreamID = 1 , ULONG nPMT_PID = 4096 , ULONG nPCR_PID = 4097 , ULONG nVideo_PID = 256 , ULONG nAudio_PID = 257 ,\
 ULONG nVideo_CodecID = 0  , ULONG nAudio_CodecID = 0  , ULONG nPCRInterval = 0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_TS_OVER_HTTP_SERVER)( UINT iSvrNum  , PVOID * ppServer , ULONG nNetworkPort_HTTP = 8888 , CHAR * pszNetworkAdapterIP = NULL , ULONG nServiceID = 1 ,\
 CHAR * pszServiceName = NULL , CHAR * pszServiceProviderName = NULL , ULONG nTransferBitRate = 0  , ULONG nOriginalNetworkID = 1 , ULONG nTransportStreamID = 1 , ULONG nPMT_PID = 4096 , ULONG nPCR_PID = 4097 , ULONG nVideo_PID = 256 , ULONG nAudio_PID = 257 ,\
 ULONG nVideo_CodecID = 0  , ULONG nAudio_CodecID = 0  , ULONG nPCRInterval = 0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_TS_OVER_RTP_SERVER)( UINT iSvrNum  , CHAR * pszURL , PVOID * ppServer , CHAR * pszNetworkAdapterIP = NULL , ULONG nServiceID = 1 , CHAR * pszServiceName = NULL ,\
 CHAR * pszServiceProviderName = NULL , BOOL bEnableCBRMode = TRUE , ULONG nTransferBitRate = 0  , ULONG nOriginalNetworkID = 1 , ULONG nTransportStreamID = 1 , ULONG nPMT_PID = 4096 , ULONG nPCR_PID = 4097 , ULONG nVideo_PID = 256 ,\
 ULONG nAudio_PID = 257 , ULONG nVideo_CodecID = 0  , ULONG nAudio_CodecID = 0  , ULONG nPCRInterval = 0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_TS_OVER_TCP_PASSIVE_SERVER)( UINT iSvrNum  , CHAR * pszURL , PVOID * ppServer , ULONG nServiceID = 1 , CHAR * pszServiceName = NULL , CHAR * pszServiceProviderName = NULL ,\
 ULONG nTransferBitRate = 0  , ULONG nOriginalNetworkID = 1 , ULONG nTransportStreamID = 1 , ULONG nPMT_PID = 4096 , ULONG nPCR_PID = 4097 , ULONG nVideo_PID = 256 , ULONG nAudio_PID = 257 , ULONG nVideo_CodecID = 0  ,\
 ULONG nAudio_CodecID = 0  , ULONG nPCRInterval = 0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_NDI_SERVER)( UINT iSvrNum  , CHAR * pszNDIName , CHAR * pszGroups , PVOID * ppServer , CHAR * pszConnectionMetadata  = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_DESTROY_BROADCAST_SERVER)( PVOID pServer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_START_BROADCAST_SERVER)( PVOID pServer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_STOP_BROADCAST_SERVER)( PVOID pServer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE)( PVOID pServer , UINT iSessionNum , PVOID pDevice , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX)( PVOID pServer , UINT iSessionNum , PVOID pDevice , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY)( PVOID pServer , UINT iSessionNum , CHAR * * ppszSessionName , ULONG * pVideoDelayLiveDuration  , ULONG * pAudioDelayLiveDuration   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY)( PVOID pServer , UINT iSessionNum , CHAR * pszSessionName  , ULONG nVideoDelayLiveDuration  , ULONG nAudioDelayLiveDuration   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY)( PVOID pServer , UINT iSessionNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pColorSpaceType , ULONG * pWidth ,\
 ULONG * pHeight , double * pFrameRate , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pAspectRatioX , ULONG * pAspectRatioY , HWND * pAttachedWindow = NULL , BOOL * pThumbDraw = NULL , BOOL * pMaintainAspectRatio = NULL ,\
 DWORD * pFlags = NULL                     );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY)( PVOID pServer , UINT iSessionNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nColorSpaceType ,  ULONG   nWidth ,\
  ULONG   nHeight ,  double   dFrameRate ,  ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  HWND   hAttachedWindow = NULL ,  BOOL   bThumbDraw = FALSE , BOOL   bMaintainAspectRatio = FALSE ,\
 DWORD  dwFlags = QCAP_BROADCAST_FLAG_FULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pColorSpaceType , ULONG * pWidth ,\
 ULONG * pHeight , double * pFrameRate , ULONG * pRecordProfile  , ULONG * pRecordLevel  , ULONG * pRecordEntropy  , ULONG * pRecordComplexity  , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pBFrames  , BOOL * pIsInterleaved  ,\
 ULONG * pSlices  , ULONG * pLayers  , ULONG * pSceneCut  , BOOL * pMultiThread  , BOOL * pMBBRC  , BOOL * pExtBRC  , ULONG * pMinQP  , ULONG * pMaxQP  , ULONG * pVBVMaxRate  , ULONG * pVBVBufSize  , ULONG * pCBRVariation  ,\
 ULONG * pAspectRatioX , ULONG * pAspectRatioY , HWND * pAttachedWindow = NULL , BOOL * pThumbDraw = NULL , BOOL * pMaintainAspectRatio = NULL , DWORD * pFlags = NULL                     );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nColorSpaceType ,  ULONG   nWidth ,\
  ULONG   nHeight ,  double   dFrameRate ,  ULONG   nRecordProfile   , ULONG   nRecordLevel   , ULONG   nRecordEntropy   , ULONG   nRecordComplexity   , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nBFrames   ,\
 BOOL   bIsInterleaved   , ULONG   nSlices   , ULONG   nLayers   , ULONG   nSceneCut   , BOOL   bMultiThread   , BOOL   bMBBRC   , BOOL   bExtBRC   , ULONG   nMinQP   , ULONG   nMaxQP   , ULONG   nVBVMaxRate   , ULONG   nVBVBufSize   ,\
 ULONG   nCBRVariation   , ULONG   nAspectRatioX ,  ULONG   nAspectRatioY ,  HWND   hAttachedWindow = NULL ,  BOOL   bThumbDraw = FALSE , BOOL   bMaintainAspectRatio = FALSE , DWORD  dwFlags = QCAP_BROADCAST_FLAG_FULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY)( PVOID pServer , UINT iSessionNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY)( PVOID pServer , UINT iSessionNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample ,\
 ULONG * pSampleFrequency , ULONG * pBitRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,\
  ULONG   nSampleFrequency ,  ULONG   nBitRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG * pTracks , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pChannels ,\
 ULONG * pBitsPerSample , ULONG * pSampleFrequency , ULONG * pBitRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer , UINT iSessionNum , ULONG   nTracks ,  ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nChannels ,\
  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency ,  ULONG   nBitRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER)( PVOID pServer , UINT iSessionNum , UINT * pSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER)( PVOID pServer , UINT iSessionNum , UINT   iSoundNum   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_SERVER_VOLUME)( PVOID pServer , UINT iSessionNum , ULONG * pVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_VOLUME)( PVOID pServer , UINT iSessionNum , ULONG   nVolume   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_SERVER_NETWORK_QOS_STATUS)( PVOID pServer , UINT iSessionNum , BOOL * pIsTransferBusy , ULONG * pQueueFrames , ULONG * pQueueBytes  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_SERVER_NETWORK_QOS_STATUS)( PVOID pServer , UINT iSessionNum , BOOL * pIsTransferBusy , ULONG * pQueueFrames , ULONG * pQueueBytes  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH , BOOL bForceKeyFrame = FALSE , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX)( PVOID pServer , UINT iSessionNum , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , BYTE * pStreamBuffer , ULONG nStreamBufferLen , ULONG bIsKeyFrame , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , BYTE * pStreamBuffer , ULONG nStreamBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH , ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX)( PVOID pServer , UINT iSessionNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer ,\
 ULONG nFrameBufferLen , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE , BOOL bLeftRightSwap = FALSE ,\
 BOOL bForceKeyFrame = FALSE , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , UINT iMixNum , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER_EX)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , UINT iMixNum , ULONG nChannels , ULONG nBitsPerSample ,\
 ULONG nSampleFrequency , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_COMPRESSION_BUFFER)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , BYTE * pStreamBuffer , ULONG nStreamBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CLEAR_VIDEO_BROADCAST_SERVER_DELAY_LIVE_BUFFER)( PVOID pServer , UINT iSessionNum , BOOL bEnableClear , BYTE * pStreamBuffer , ULONG nStreamBufferLen , ULONG bIsKeyFrame , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CLEAR_AUDIO_BROADCAST_SERVER_DELAY_LIVE_BUFFER)( PVOID pServer , UINT iSessionNum , BOOL bEnableClear , BYTE * pStreamBuffer , ULONG nStreamBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CLEAR_AUDIO_MX_BROADCAST_SERVER_DELAY_LIVE_BUFFER)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , BOOL bEnableClear , BYTE * pStreamBuffer , ULONG nStreamBufferLen , double dSampleTime = 0.0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_SERVER_BMP)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_SERVER_JPG)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW ,\
 ULONG nDstH , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW ,\
 ULONG nDstH , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_MOVE_OSD_BROADCAST_SERVER_OBJECT)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY_W)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_TEXT)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_TEXT_W)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX_W)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_PICTURE)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszFilePathName , ULONG nTransparent ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_BUFFER)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer ,\
 ULONG nFrameWidth , ULONG nFrameHeight , ULONG nFramePitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 ,\
 BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_SERVER_BUFFER_EX)( PVOID pServer , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer ,\
 ULONG nFrameWidth , ULONG nFrameHeight , ULONG nFramePitch , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  ,\
 ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

////

////

////

////

////

////

////

////

////

////

////

////

// BROADCASTING RTSP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 4 , &pServer, "root", "root", 554 );
//
//         CH01 URL -> rtsp://root:root@127.0.0.1:554/session0.mpg
//
//         CH02 URL -> rtsp://root:root@127.0.0.1:554/session1.mpg
//
//         CH03 URL -> rtsp://root:root@127.0.0.1:554/session2.mpg
//
//         CH04 URL -> rtsp://root:root@127.0.0.1:554/session3.mpg
// 
// STEP#02 QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 0 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 1 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 2 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 3 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 0 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 1 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 2 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 3 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
// STEP#03 QCAP_START_BROADCAST_SERVER( pServer );
//
// STEP#04 QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferD, nFrameBufferLenD );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 , pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 , pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 , pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 , pFrameBufferD, nFrameBufferLenD );
//
// STEP#05 QCAP_STOP_BROADCAST_SERVER( pServer );
//
// STEP#06 QCAP_DRSTROY_BROADCAST_SERVER( pServer );

// BROADCASTING RTMP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 4 , &pServer, NULL, NULL, 1935 );
//
//         CH01 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session0.mpg (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session1.mpg
//
//         CH03 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session2.mpg
//
//         CH04 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session3.mpg

// BROADCASTING HLS SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 4 , &pServer, "C:\\AppServ\\www\\", "hls\\", 3000 ); // HERE, C:\\AppServ\\www\\ IS YOUR WEB SERVER ROOT FOLDER, hls\\ is SUB FOLDER TO SAVE HLS FILES
//
//         CH01 URL -> http://xxx.xxx.xxx.xxx/hls/session0.m3u8 (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> http://xxx.xxx.xxx.xxx/hls/session1.m3u8
//
//         CH03 URL -> http://xxx.xxx.xxx.xxx/hls/session2.m3u8
//
//         CH04 URL -> http://xxx.xxx.xxx.xxx/hls/session3.m3u8

// BROADCASTING UDP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER( 0, "udp://xxx.xxx.xxx.xxx:xxx", &pServer );

// ##########################################################################################################################################################################################
// #
// # BROADCASTING CLIENT FUNCTIONS (RTSP/RTMP/TS) (2D/3D)
// #
// ##########################################################################################################################################################################################
//












QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_CLIENT)( UINT iCliNum  , CHAR * pszURL , PVOID * ppClient , ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE , HWND hAttachedWindow = NULL , BOOL bThumbDraw = FALSE ,\
 BOOL bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_BROADCAST_CLIENT_EX)( UINT iCliNum  , CHAR * pszURL , PVOID * ppClient , ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE , CHAR * pszNetworkAdapterIP = NULL ,\
 HWND hAttachedWindow = NULL , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_3D_BROADCAST_CLIENT)( UINT iCliNum  , CHAR * pszURL , PVOID * ppClient , ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE , HWND hAttachedWindowL = NULL ,\
 BOOL bThumbDrawL = FALSE , BOOL bMaintainAspectRatioL = FALSE , HWND hAttachedWindowR = NULL , BOOL bThumbDrawR = FALSE , BOOL bMaintainAspectRatioR = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_3D_BROADCAST_CLIENT_EX)( UINT iCliNum  , CHAR * pszURL , PVOID * ppClient , ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE , CHAR * pszNetworkAdapterIP = NULL ,\
 HWND hAttachedWindowL = NULL , BOOL bThumbDrawL = FALSE , BOOL bMaintainAspectRatioL = FALSE , HWND hAttachedWindowR = NULL , BOOL bThumbDrawR = FALSE , BOOL bMaintainAspectRatioR = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_DESTROY_BROADCAST_CLIENT)( PVOID pClient  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_START_BROADCAST_CLIENT)( PVOID pClient , ULONG nProtocol = QCAP_BROADCAST_PROTOCOL_TCP  , ULONG nReconnectionTimeout = 3000  , ULONG nDelayQueueDuration = 0   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_START_BROADCAST_CLIENT_EX)( PVOID pClient , ULONG nProtocol = QCAP_BROADCAST_PROTOCOL_TCP  , ULONG nReconnectionTimeout = 3000  , ULONG nDelayQueueDuration = 0  ,\
 BOOL bEnableUltraLowLatency = FALSE , ULONG nAnalyzeDuration = 0  , ULONG nProbeDurationSizeKB = 0 , CHAR * pszEncryptKey = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_STOP_BROADCAST_CLIENT)( PVOID pClient  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_BROADCAST_CLIENT_OUTPUT_STREAMS)( PVOID pClient , UINT iSessionNum , ULONG * pVideoStream_PID , ULONG * pAudioStream_PID , HWND * pAttachedWindow = NULL , BOOL * pThumbDraw = NULL ,\
 BOOL * pMaintainAspectRatio = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_BROADCAST_CLIENT_OUTPUT_STREAMS)( PVOID pClient , UINT iSessionNum , ULONG nVideoStream_PID , ULONG nAudioStream_PID , HWND hAttachedWindow = NULL , BOOL bThumbDraw = FALSE ,\
 BOOL bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_DIAGNOSE_VIDEO_BROADCAST_CLIENT_STREAM_STATUS)( PVOID pClient , UINT iSessionNum , BOOL * pIsStill , ULONG nStillThreshold = 64  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_DIAGNOSE_AUDIO_BROADCAST_CLIENT_STREAM_STATUS)( PVOID pClient , UINT iSessionNum , double * pVolumeDB_L  , double * pVolumeDB_R   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE)( PVOID pClient , UINT iSessionNum , ULONG * pStereoDisplayMode , BOOL * pLeftRightSwap  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE)( PVOID pClient , UINT iSessionNum , ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE , BOOL bLeftRightSwap = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE)( PVOID pClient , UINT iSessionNum , ULONG * pType  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE)( PVOID pClient , UINT iSessionNum , ULONG nType  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE)( PVOID pClient , UINT iSessionNum , BOOL * pEnable  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE)( PVOID pClient , UINT iSessionNum , BOOL bEnable  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY)( PVOID pClient , UINT iSessionNum , ULONG * pCropX , ULONG * pCropY , ULONG * pCropW , ULONG * pCropH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY)( PVOID pClient , UINT iSessionNum , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR)( PVOID pClient , UINT iSessionNum , BOOL * pHorizontalMirror , BOOL * pVerticalMirror  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR)( PVOID pClient , UINT iSessionNum , BOOL bHorizontalMirror , BOOL bVerticalMirror  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS)( PVOID pClient , UINT iSessionNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS)( PVOID pClient , UINT iSessionNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_CONTRAST)( PVOID pClient , UINT iSessionNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_CONTRAST)( PVOID pClient , UINT iSessionNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_HUE)( PVOID pClient , UINT iSessionNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_HUE)( PVOID pClient , UINT iSessionNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_BROADCAST_CLIENT_SATURATION)( PVOID pClient , UINT iSessionNum , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_BROADCAST_CLIENT_SATURATION)( PVOID pClient , UINT iSessionNum , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER)( PVOID pClient , UINT iSessionNum , UINT * pSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER)( PVOID pClient , UINT iSessionNum , UINT iSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME)( PVOID pClient , UINT iSessionNum , ULONG * pVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME)( PVOID pClient , UINT iSessionNum , ULONG nVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_START_BROADCAST_CLIENT_TIMESHIFT_RECORD)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID * ppPhysicalFileWriter , double dVideoDelayTime = 0.0 , double dAudioDelayTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_START_BROADCAST_CLIENT_RECORD)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , double dVideoDelayTime = 0.0 , double dAudioDelayTime = 0.0 , double dSegmentDurationTime = 0.0 ,\
 ULONG nSegmentDurationSizeKB = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_STOP_BROADCAST_CLIENT_RECORD)( PVOID pClient , UINT iSessionNum , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_RESUME_BROADCAST_CLIENT_RECORD)( PVOID pClient , UINT iSessionNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_PAUSE_BROADCAST_CLIENT_RECORD)( PVOID pClient , UINT iSessionNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW ,\
 ULONG nDstH , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW ,\
 ULONG nDstH , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_MOVE_OSD_BROADCAST_CLIENT_OBJECT)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY_W)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_W)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX_W)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName ,\
 ULONG nFontStyle , ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszFilePathName , ULONG nTransparent ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer ,\
 ULONG nFrameWidth , ULONG nFrameHeight , ULONG nFramePitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 ,\
 BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER_EX)( PVOID pClient , UINT iSessionNum , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer ,\
 ULONG nFrameWidth , ULONG nFrameHeight , ULONG nFramePitch , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  ,\
 ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY)( PVOID pClient , CHAR * pszProperty , CHAR * * ppszValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY)( PVOID pClient , CHAR * pszProperty , CHAR * pszValue  );

////

////

////

////

////

////

////

////

////

////

////

////

// BROADCASTING CLIENT EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_CLIENT( 0, "rtsp://root:root@127.0.0.1:554/session0.mpg", &pClient, QCAP_DECODER_TYPE_SOFTWARE, hWindow, TRUE );
//
////
//
////
//
// STEP#03 QCAP_START_BROADCAST_CLIENT( pClient );
//
// STEP#04 QCAP_STOP_BROADCAST_CLIENT( pClient );
//
// STEP#05 QCAP_DESTROY_BROADCAST_CLIENT( pClient );

// ##########################################################################################################################################################################################
// #
// # ONVIF COMMUNICATION FUNCTIONS (SERVER/EMULATOR/CLIENT)
// #
// ##########################################################################################################################################################################################
//
// COMMUNICATION SERVER FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//




QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_COMMUNICATION_ONVIF_SERVER)( ULONG nTotalVideoSources , ULONG nTotalAudioSources , ULONG nTotalVideoEncoders , ULONG nTotalAudioEncoders , ULONG nTotalProfiles ,\
 PVOID * ppServer , CHAR * pszName = NULL , CHAR * pszLocation = NULL , CHAR * pszManufacturer = NULL , CHAR * pszModel = NULL , CHAR * pszHardwareVersion = NULL , CHAR * pszFirmwareVersion = NULL , CHAR * pszDeviceID = NULL , CHAR * pszRootAccount = NULL ,\
 CHAR * pszRootPassword = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_COMMUNICATION_SERVER)( PVOID pServer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_COMMUNICATION_SERVER)( PVOID pServer , ULONG nNetworkPort = 8001  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_COMMUNICATION_SERVER)( PVOID pServer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE)( PVOID pServer , UINT iVidSrcNum , ULONG * pWidth , ULONG * pHeight , ULONG * pFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE)( PVOID pServer , UINT iVidSrcNum , ULONG   nWidth ,  ULONG   nHeight ,  ULONG   nFrameRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE)( PVOID pServer , UINT iAudSrcNum , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE)( PVOID pServer , UINT iAudSrcNum , ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER)( PVOID pServer , UINT iVidEncNum , ULONG * pEncoderFormat , ULONG * pWidth , ULONG * pHeight , ULONG * pFrameRate_Min , ULONG * pFrameRate_Max ,\
 ULONG * pFrameRate_Default , ULONG * pRecordMode_Min , ULONG * pRecordMode_Max , ULONG * pRecordMode_Default , ULONG * pQuality_Min , ULONG * pQuality_Max , ULONG * pQuality_Default , ULONG * pBitRate_Min , ULONG * pBitRate_Max ,\
 ULONG * pBitRate_Default , ULONG * pGOP_Min , ULONG * pGOP_Max , ULONG * pGOP_Default  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER)( PVOID pServer , UINT iVidEncNum , ULONG   nEncoderFormat ,  ULONG   nWidth ,  ULONG   nHeight ,  ULONG   nFrameRate_Min ,\
  ULONG   nFrameRate_Max ,  ULONG   nFrameRate_Default ,  ULONG   nRecordMode_Min ,  ULONG   nRecordMode_Max ,  ULONG   nRecordMode_Default ,  ULONG   nQuality_Min ,  ULONG   nQuality_Max ,  ULONG   nQuality_Default ,  ULONG   nBitRate_Min ,  ULONG   nBitRate_Max ,\
  ULONG   nBitRate_Default ,  ULONG   nGOP_Min ,  ULONG   nGOP_Max ,  ULONG   nGOP_Default   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER)( PVOID pServer , UINT iAudEncNum , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency ,\
 ULONG * pBitRate_Min , ULONG * pBitRate_Max , ULONG * pBitRate_Default  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER)( PVOID pServer , UINT iAudEncNum , ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency ,\
  ULONG   nBitRate_Min ,  ULONG   nBitRate_Max ,  ULONG   nBitRate_Default   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_PROFILE)( PVOID pServer , UINT iProNum , CHAR * * ppszURL , UINT * pVidSrcNum , UINT * pAudSrcNum , UINT * pVidEncNum , UINT * pAudEncNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_PROFILE)( PVOID pServer , UINT iProNum , CHAR *   pszURL ,   UINT   iVidSrcNum ,  UINT   iAudSrcNum ,  UINT   iVidEncNum ,  UINT   iAudEncNum   );

////

////

////

////

// COMMUNICATION EMULATOR FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR)( PVOID * ppEmulator  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_COMMUNICATION_EMULATOR)( PVOID pEmulator  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_COMMUNICATION_EMULATOR)( PVOID pEmulator  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_COMMUNICATION_EMULATOR)( PVOID pEmulator  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO)( PVOID pEmulator , UINT iSvrNum , CHAR * * ppszNetworkIP , ULONG * pNetworkPort , CHAR * * ppszNetworkURL  );

////

// COMMUNICATION CLIENT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT)( CHAR * pszNetworkURL , PVOID * ppClient , CHAR * pszAccount = NULL  , CHAR * pszPassword = NULL   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_COMMUNICATION_CLIENT)( PVOID pClient  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_COMMUNICATION_CLIENT)( PVOID pClient  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_COMMUNICATION_CLIENT)( PVOID pClient  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_VIDEO_SOURCE_INFO)( PVOID pClient , UINT iVidSrcNum , ULONG * pWidth , ULONG * pHeight , ULONG * pFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_AUDIO_SOURCE_INFO)( PVOID pClient , UINT iAudSrcNum , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_INFO)( PVOID pClient , UINT iVidEncNum , ULONG * pTotalVidEncOptions , UINT * pVidEncOptionNum_Default  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_INFO)( PVOID pClient , UINT iAudEncNum , ULONG * pTotalAudEncOptions , UINT * pAudEncOptionNum_Default  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_OPTION_INFO)( PVOID pClient , UINT iVidEncNum , UINT iVidEncOptionNum , ULONG * pEncoderFormat , ULONG * pWidthList , ULONG * pWidthListSize ,\
 ULONG * pWidth_Default , ULONG * pHeightList , ULONG * pHeightListSize , ULONG * pHeight_Default , ULONG * pFrameRate_Min , ULONG * pFrameRate_Max , ULONG * pFrameRate_Default , ULONG * pRecordMode_Min , ULONG * pRecordMode_Max ,\
 ULONG * pRecordMode_Default , ULONG * pQuality_Min , ULONG * pQuality_Max , ULONG * pQuality_Default , ULONG * pBitRate_Min , ULONG * pBitRate_Max , ULONG * pBitRate_Default , ULONG * pGOP_Min , ULONG * pGOP_Max , ULONG * pGOP_Default  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_OPTION_INFO)( PVOID pClient , UINT iAudEncNum , UINT iAudEncOptionNum , ULONG * pEncoderFormat , ULONG * pChannelsList , ULONG * pChannelsListSize ,\
 ULONG * pChannels_Default , ULONG * pBitsPerSampleList , ULONG * pBitsPerSampleListSize , ULONG * pBitsPerSample_Default , ULONG * pSampleFrequencyList , ULONG * pSampleFrequencyListSize , ULONG * pSampleFrequency_Default ,\
 ULONG * pBitRate_Min , ULONG * pBitRate_Max , ULONG * pBitRate_Default  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_PROFILE_INFO)( PVOID pClient , UINT iProNum , CHAR * * ppszURL , UINT * pVidSrcNum , UINT * pAudSrcNum , UINT * pVidEncNum , UINT * pAudEncNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY)( PVOID pClient , UINT iProNum , ULONG * pEncoderFormat , ULONG * pWidth , ULONG * pHeight , ULONG * pFrameRate ,\
 ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY)( PVOID pClient , UINT iProNum , ULONG   nEncoderFormat ,  ULONG   nWidth ,  ULONG   nHeight ,  ULONG   nFrameRate ,\
  ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY)( PVOID pClient , UINT iProNum , ULONG * pEncoderFormat , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency , ULONG * pBitRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY)( PVOID pClient , UINT iProNum , ULONG   nEncoderFormat ,  ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency ,  ULONG   nBitRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY)( PVOID pClient , CHAR * pszProperty , CHAR * * ppszValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY)( PVOID pClient , CHAR * pszProperty , CHAR * pszValue  );

////

// ##########################################################################################################################################################################################
// #
// # WEBRTC FUNCTIONS (CHATROOM)
// #
// ##########################################################################################################################################################################################
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_WEBRTC_CHATROOM)( ULONG nNetworkPort , PVOID * ppChatRoom  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_WEBRTC_CHATROOM)( PVOID pChatRoom  );

// ##########################################################################################################################################################################################
// #
// # WEBRTC FUNCTIONS (P2P)
// #
// ##########################################################################################################################################################################################
//





////

////

////

////

////

////

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_WEBRTC_CHATTER)( CHAR * pszChatRoomLoginIP , ULONG nChatRoomLoginPort , CHAR * pszUserName , PVOID * ppChatter , ULONG  * pLoginID , ULONG nConnectionTimeout = 5000 ,\
 CHAR * pszStunURL = NULL , CHAR * pszReceivedFileFolderPath = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_WEBRTC_CHATTER)( PVOID pChatter  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_WEBRTC_CHAT)( PVOID pChatter , ULONG nPeerID  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_WEBRTC_CHAT)( PVOID pChatter  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_WEBRTC_SENDER)( PVOID pChatter , UINT iSvrNum  , PVOID * ppServer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_WEBRTC_RECEIVER)( PVOID pChatter , UINT iCliNum  , PVOID * ppClient , ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE , HWND hAttachedWindow = NULL , BOOL bThumbDraw = FALSE ,\
 BOOL bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_WEBRTC_PRIVATE_SDP_PROPERTY)( PVOID pChatter , ULONG nPeerID , CHAR * pszSDP  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_ENUM_WEBRTC_USER_IN_CHATROOM)( PVOID pChatter , ULONG * pPeerID , CHAR * * ppszPeerUserName , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SEND_WEBRTC_DATA)( PVOID pChatter , CHAR * pszData  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SEND_WEBRTC_FILE)( PVOID pChatter , CHAR * pszFilePathName  );

////

////

////

////

////

////

////

////

////

////

////

// ##########################################################################################################################################################################################
// #
// # FILE PLAYBACK FUNCTIONS (PLAYBACK/EDITING/REPAIR/FILE)
// #
// ##########################################################################################################################################################################################
//
// FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 







QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_OPEN_FILE)( CHAR * pszFileName , PVOID * ppFile , ULONG nDecoderType , ULONG * pVideoEncoderFormat , ULONG * pVideoWidth , ULONG * pVideoHeight , double * pVideoFrameRate ,\
 ULONG * pAudioEncoderFormat , ULONG * pAudioChannels , ULONG * pAudioBitsPerSample , ULONG * pAudioSampleFrequency , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames ,\
 HWND hAttachedWindow , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE , BOOL bEnableEditFunction = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_OPEN_FILE_EX)( CHAR * pszFileName , PVOID * ppFile , ULONG nDecoderType , ULONG * pVideoEncoderFormat , ULONG * pVideoWidth , ULONG * pVideoHeight , double * pVideoFrameRate ,\
 ULONG * pAudioEncoderFormat , ULONG * pAudioChannels , ULONG * pAudioBitsPerSample , ULONG * pAudioSampleFrequency , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames ,\
 HWND hAttachedWindow , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_OPEN_3D_FILE)( CHAR * pszFileName , PVOID * ppFile , BOOL * pIs3D , ULONG nDecoderType , ULONG * pVideoEncoderFormat , ULONG * pVideoWidth , ULONG * pVideoHeight ,\
 double * pVideoFrameRate , ULONG * pAudioEncoderFormat , ULONG * pAudioChannels , ULONG * pAudioBitsPerSample , ULONG * pAudioSampleFrequency , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames ,\
 HWND hAttachedWindowL , BOOL bThumbDrawL = FALSE , BOOL bMaintainAspectRatioL = FALSE , HWND hAttachedWindowR = NULL , BOOL bThumbDrawR = FALSE , BOOL bMaintainAspectRatioR = FALSE , BOOL bEnableEditFunction = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_OPEN_TIMESHIFT_FILE_EX)( PVOID pPhysicalFileWriter , PVOID * ppFile , ULONG nDecoderType , ULONG * pVideoEncoderFormat , ULONG * pVideoWidth , ULONG * pVideoHeight ,\
 double * pVideoFrameRate , ULONG * pAudioEncoderFormat , ULONG * pAudioChannels , ULONG * pAudioBitsPerSample , ULONG * pAudioSampleFrequency , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames ,\
 HWND hAttachedWindow , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_OPEN_SCF_FILE)( UINT iChNum , PVOID * ppFile , ULONG nDecoderType , HWND hAttachedWindow , BOOL bThumbDraw = FALSE , BOOL bMaintainAspectRatio = FALSE , double dStartSampleTime = 0.0 ,\
 double dStopSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_DESTROY_FILE)( PVOID pFile  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_PLAY_FILE)( PVOID pFile  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_PAUSE_FILE)( PVOID pFile  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_STOP_FILE)( PVOID pFile  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_PLAY_GLOBAL_SCF_FILE)();

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_PAUSE_GLOBAL_SCF_FILE)();

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_STOP_GLOBAL_SCF_FILE)();

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_REFRESH_TIMESHIFT_FILE_INFO)( PVOID pFile , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SCF_FILE_ENUMERATION)( UINT iChNum , double dStartSearchTime , double dStopSearchTime , ULONG * pFileSizeHigh , ULONG * pFileSizeLow , double * pFileStartTime ,\
 double * pFileStopTime , double * pVideoStartTime , double * pVideoStopTime , double * pAudioStartTime , double * pAudioStopTime , ULONG * pVideoEncoderFormat , ULONG * pVideoWidth , ULONG * pVideoHeight , double * pVideoFrameRate , ULONG * pAudioEncoderFormat ,\
 ULONG * pAudioChannels , ULONG * pAudioBitsPerSample , ULONG * pAudioSampleFrequency , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_SCF_FILE_TIMER)( UINT iChNum , BOOL bEnableGlobalTimer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_FILE_POSITION)( PVOID pFile , double * pSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_FILE_POSITION)( PVOID pFile , double dSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_FILE_POSITION_EX)( PVOID pFile , double * pSampleTime , ULONG nTimeUnit = QCAP_FILE_TIMEUNIT_FRAME  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_FILE_POSITION_EX)( PVOID pFile , double dSampleTime , ULONG nTimeUnit = QCAP_FILE_TIMEUNIT_FRAME  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_GLOBAL_SCF_FILE_POSITION)( double * pSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_GLOBAL_SCF_FILE_POSITION)( double dSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_FILE_PLAYBACK_SPEED)( PVOID pFile , double * pSpeed  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_FILE_PLAYBACK_SPEED)( PVOID pFile , double dSpeed  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_STREAM_BUFFER)( PVOID pFile , UINT iFrameNum , BYTE * pStreamBuffer , ULONG * pStreamBufferLen , BOOL * pIsKeyFrame , double * pSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_FILE_STREAM_BUFFER)( PVOID pFile , UINT iFrameNum , BYTE * pStreamBuffer , ULONG * pStreamBufferLen , double * pSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_METADATA_FILE_DATA_BUFFER)( PVOID pFile , UINT iFrameNum , BYTE * pDataBuffer , ULONG * pDataBufferLen , double * pSampleTime  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_METADATA_FILE_HEADER)( PVOID pFile , CHAR * * ppszTitle , CHAR * * ppszArtist , CHAR * * ppszComments , CHAR * * ppszGenre , CHAR * * ppszComposer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_METADATA_FILE_HEADER_W)( PVOID pFile , WSTRING * ppwszTitle , WSTRING * ppwszArtist , WSTRING * ppwszComments , WSTRING * ppwszGenre , WSTRING * ppwszComposer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE)( PVOID pFile , ULONG * pStereoDisplayMode , BOOL * pLeftRightSwap  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE)( PVOID pFile , ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE , BOOL bLeftRightSwap = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_REGION_DISPLAY)( PVOID pFile , ULONG * pCropX , ULONG * pCropY , ULONG * pCropW , ULONG * pCropH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_FILE_REGION_DISPLAY)( PVOID pFile , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_MIRROR)( PVOID pFile , BOOL * pHorizontalMirror , BOOL * pVerticalMirror  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_FILE_MIRROR)( PVOID pFile , BOOL bHorizontalMirror , BOOL bVerticalMirror  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_BRIGHTNESS)( PVOID pFile , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_FILE_BRIGHTNESS)( PVOID pFile , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_CONTRAST)( PVOID pFile , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_FILE_CONTRAST)( PVOID pFile , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_HUE)( PVOID pFile , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_FILE_HUE)( PVOID pFile , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_FILE_SATURATION)( PVOID pFile , ULONG * pValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_FILE_SATURATION)( PVOID pFile , ULONG nValue  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_FILE_SOUND_RENDERER)( PVOID pFile , UINT * pSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_FILE_SOUND_RENDERER)( PVOID pFile , UINT iSoundNum  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_FILE_VOLUME)( PVOID pFile , ULONG * pVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_FILE_VOLUME)( PVOID pFile , ULONG nVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_FILE_BMP)( PVOID pFile , CHAR * pszFilePathName , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_FILE_JPG)( PVOID pFile , CHAR * pszFilePathName , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_FILE_BMP_EX)( PVOID pFile , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_FILE_JPG_EX)( PVOID pFile , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH , ULONG nQuality ,\
 BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_MOVE_OSD_FILE_OBJECT)( PVOID pFile , UINT iOsdNum , INT x , INT y , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_FILE_TEXT_BOUNDARY)( PVOID pFile , UINT iOsdNum , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_FILE_TEXT_BOUNDARY_W)( PVOID pFile , UINT iOsdNum , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_TEXT)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_TEXT_W)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_TEXT_EX)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_TEXT_EX_W)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_PICTURE)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszFilePathName , ULONG nTransparent , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_BUFFER)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth , ULONG nFrameHeight ,\
 ULONG nFramePitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_FILE_BUFFER_EX)( PVOID pFile , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth , ULONG nFrameHeight ,\
 ULONG nFramePitch , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  ,\
 BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

////

////

////

////

////

////

////

// FILE EDITING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_EXPORT_FILE)( PVOID pFile , double dStartSampleTime , double dStopSampleTime , CHAR * pszExportedFileName  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_EXPORT_FILE_EX)( PVOID pFile , CHAR * pszExportedFileName , ULONG nFileArgs , double dStartSampleTime1 , double dStopSampleTime1 , double dStartSampleTime2 , double dStopSampleTime2 , ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_EXPORT_FILE_EX_C)( PVOID pFile , CHAR * pszExportedFileName , ULONG nFileArgs , double dStartSampleTimes[ ] , double dStopSampleTimes[ ]  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_EXPORT_FILES_EX)( PVOID pFile , ULONG nFileArgs , double dStartSampleTime1 , double dStopSampleTime1 , CHAR * pszExportedFileName1 , double dStartSampleTime2 , double dStopSampleTime2 ,\
 CHAR * pszExportedFileName2 , ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_EXPORT_FILES_EX_C)( PVOID pFile , ULONG nFileArgs , double dStartSampleTimes[ ] , double dStopSampleTimes[ ] , CHAR * pszExportedFileNames[ ]  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MERGE_FILES)( CHAR * pszFrontEndFileName , CHAR * pszBackEndFileName , CHAR * pszMergedFileName  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MERGE_FILES_EX)( CHAR * pszMergedFileName , ULONG nFileArgs , CHAR * pszSourceFileName1 , CHAR * pszSourceFileName2 , ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MERGE_FILES_EX_C)( CHAR * pszMergedFileName , ULONG nFileArgs , CHAR * pszSourceFileNames[ ]  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MERGE_FILES_BY_EDL)( CHAR * pszEDLFileName  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_BUILD_VIDEO_ON_DEMAND_FILE)( CHAR * pszOriginalFileName , CHAR * pszVideoOnDemandFileName  );

// FILE REPAIR FUNCTIONS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DIAGNOSE_FILE)( CHAR * pszFileName , BOOL * pIsHealthy  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REPAIR_FILE)( CHAR * pszBadFileName , CHAR * pszRepairedFileName  );

// FILE TRANSCODING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_FILE_TRANSCODER)( CHAR * pszSrcFileName , PVOID * ppFileTranscoder , ULONG nDecoderType , ULONG * pVideoEncoderFormat , ULONG * pVideoWidth , ULONG * pVideoHeight ,\
 double * pVideoFrameRate , ULONG * pAudioEncoderFormat , ULONG * pAudioChannels , ULONG * pAudioBitsPerSample , ULONG * pAudioSampleFrequency , double * pTotalDurationTimes , ULONG * pTotalVideoFrames , ULONG * pTotalAudioFrames , ULONG * pTotalMetadataFrames  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_FILE_TRANSCODER)( PVOID pFileTranscoder  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY)( PVOID pFileTranscoder , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pWidth , ULONG * pHeight , double * pFrameRate ,\
 ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pAspectRatioX , ULONG * pAspectRatioY  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY)( PVOID pFileTranscoder , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nWidth ,  ULONG   nHeight ,  double   dFrameRate ,\
  ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nAspectRatioX ,  ULONG   nAspectRatioY   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY_EX)( PVOID pFileTranscoder , ULONG * pEncoderType , ULONG * pEncoderFormat , ULONG * pWidth , ULONG * pHeight , double * pFrameRate ,\
 ULONG * pRecordProfile  , ULONG * pRecordLevel  , ULONG * pRecordEntropy  , ULONG * pRecordComplexity  , ULONG * pRecordMode , ULONG * pQuality , ULONG * pBitRate , ULONG * pGOP , ULONG * pBFrames  , BOOL * pIsInterleaved  , ULONG * pSlices  ,\
 ULONG * pLayers  , ULONG * pSceneCut  , BOOL * pMultiThread  , BOOL * pMBBRC  , BOOL * pExtBRC  , ULONG * pMinQP  , ULONG * pMaxQP  , ULONG * pVBVMaxRate  , ULONG * pVBVBufSize  , ULONG * pCBRVariation  , ULONG * pAspectRatioX , ULONG * pAspectRatioY  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY_EX)( PVOID pFileTranscoder , ULONG   nEncoderType ,  ULONG   nEncoderFormat ,  ULONG   nWidth ,  ULONG   nHeight ,  double   dFrameRate ,\
  ULONG   nRecordProfile   , ULONG   nRecordLevel   , ULONG   nRecordEntropy   , ULONG   nRecordComplexity   , ULONG   nRecordMode ,  ULONG   nQuality ,  ULONG   nBitRate ,  ULONG   nGOP ,  ULONG   nBFrames   , BOOL   bIsInterleaved   ,\
 ULONG   nSlices   , ULONG   nLayers   , ULONG   nSceneCut   , BOOL   bMultiThread   , BOOL   bMBBRC   , BOOL   bExtBRC   , ULONG   nMinQP   , ULONG   nMaxQP   , ULONG   nVBVMaxRate   , ULONG   nVBVBufSize   , ULONG   nCBRVariation   , ULONG   nAspectRatioX ,  ULONG   nAspectRatioY   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_FILE_TRANSCODER)( PVOID pFileTranscoder , CHAR * pszDstFileName  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_FILE_TRANSCODER)( PVOID pFileTranscoder  );

////

// ##########################################################################################################################################################################################
// #
// # ANIMATION FUNCTIONS
// #
// ##########################################################################################################################################################################################
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_ANIMATION_CLIP)( CHAR * pszAniFileName , PVOID * ppClip , ULONG * pTotalFrames , ULONG * pTotalSprites , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_ANIMATION_CLIP)( PVOID pClip  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_ANIMATION_CLIP)( PVOID pClip  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_ANIMATION_CLIP)( PVOID pClip  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STEP_ANIMATION_CLIP)( PVOID pClip , UINT * pFrameNum , BYTE * * ppFrameBuffer , ULONG * pFrameBufferLen , BOOL bClearBackground = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SEEK_ANIMATION_CLIP)( PVOID pClip , UINT iFrameNum , BYTE * * ppFrameBuffer , ULONG * pFrameBufferLen , BOOL bClearBackground = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY)( PVOID pClip , UINT iSpriteNum , UINT iFrameNum , INT * pPositionX , INT * pPositionY , INT * pScaleW , INT * pScaleH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY)( PVOID pClip , UINT iSpriteNum , UINT iFrameNum , INT nPositionX , INT nPositionY , INT nScaleW , INT nScaleH  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY)( PVOID pClip , UINT iSpriteNum , UINT iFrameNum , double * pAlpha  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY)( PVOID pClip , UINT iSpriteNum , UINT iFrameNum , double nAlpha  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE)( PVOID pClip , UINT iSpriteNum , CHAR * pszFilePathName  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER)( PVOID pClip , UINT iSpriteNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen , BOOL bCloneCopy = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX)( PVOID pClip , UINT iSpriteNum , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , BOOL bCloneCopy = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE)( PVOID pClip , UINT iSpriteNum , PVOID pDevice , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , BOOL bCloneCopy = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX)( PVOID pClip , UINT iSpriteNum , PVOID pDevice , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 BOOL bCloneCopy = FALSE  );

// ANIMATION EXAMPLE:
//
// STEP#01 QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.FADEOUT.XML", &pClip, &nFrames, &nSprites, &nColorSpaceType, &nWidth, &nHeight );
//
// STEP#02 QCAP_START_ANIMATION_CLIP( pClip );
//
// STEP#03 QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( pClip, 0 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
// 
//         QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( pClip, 1 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
// STEP#04 QCAP_STEP_ANIMATION_CLIP( pClip, &iFrameNum, &pFrameBuffer, &nFrameBufferLen, TRUE );
//
// STEP#05 QCAP_STOP_ANIMATION_CLIP( pClip );
//
// STEP#06 QCAP_DESTROY_ANIMATION_CLIP( pClip );

// ##########################################################################################################################################################################################
// #
// # VIRTUAL CAMERA FUNCTIONS
// #
// ##########################################################################################################################################################################################
//


QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_CREATE_VIRTUAL_CAMERA)( UINT iCamNum  , PVOID * ppCamera  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_DESTROY_VIRTUAL_CAMERA)( PVOID pCamera  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera , ULONG * pColorSpaceType , ULONG * pWidth , ULONG * pHeight , double * pFrameRate  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera , ULONG   nColorSpaceType ,  ULONG   nWidth ,  ULONG   nHeight ,  double   dFrameRate   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera , ULONG * pChannels , ULONG * pBitsPerSample , ULONG * pSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera , ULONG   nChannels ,  ULONG   nBitsPerSample ,  ULONG   nSampleFrequency   );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER)( PVOID pCamera , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX)( PVOID pCamera , ULONG nColorSpaceType , ULONG nWidth , ULONG nHeight , BYTE * pFrameBuffer , ULONG nFrameBufferLen ,\
 ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER)( PVOID pCamera , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX)( PVOID pCamera , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , BYTE * pFrameBuffer , ULONG nFrameBufferLen , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER)( PVOID pCamera , UINT iMixNum , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER_EX)( PVOID pCamera , UINT iMixNum , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , BYTE * pFrameBuffer , ULONG nFrameBufferLen  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER)( PVOID pCamera , double dSampleTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_START_VIRTUAL_CAMERA)( PVOID pCamera  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_STOP_VIRTUAL_CAMERA)( PVOID pCamera  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP)( PVOID pCamera , CHAR * pszFilePathName , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG)( PVOID pCamera , CHAR * pszFilePathName , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX)( PVOID pCamera , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH ,\
 BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX)( PVOID pCamera , CHAR * pszFilePathName , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , ULONG nDstW , ULONG nDstH ,\
 ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_MOVE_OSD_VIRTUAL_CAMERA_OBJECT)( PVOID pCamera , UINT iOsdNum , INT x , INT y , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY)( PVOID pCamera , UINT iOsdNum , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth , ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY_W)( PVOID pCamera , UINT iOsdNum , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle , ULONG nFontSize , ULONG * pBoundaryWidth ,\
 ULONG * pBoundaryHeight  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle , ULONG nFontSize ,\
 DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_W)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszString , CHAR * pszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX_W)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , WSTRING pwszString , WSTRING pwszFontFamilyName , ULONG nFontStyle ,\
 ULONG nFontSize , DWORD dwFontColor , DWORD dwBackgroundColor , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , INT nTextStartPosX = 0 , INT nTextStartPosY = 0 , ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , CHAR * pszFilePathName , ULONG nTransparent , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST ,\
 double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth ,\
 ULONG nFrameHeight , ULONG nFramePitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL ,\
 ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

QCAP_EXT_API QRESULT (QCAP_EXPORT *  QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER_EX)( PVOID pCamera , UINT iOsdNum , INT x , INT y , INT w , INT h , ULONG nColorSpaceType , BYTE * pFrameBuffer , ULONG nFrameWidth ,\
 ULONG nFrameHeight , ULONG nFramePitch , ULONG nCropX , ULONG nCropY , ULONG nCropW , ULONG nCropH , DWORD dwBorderColor , ULONG nBorderWidth , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  , ULONG nKeyColorBlurLevel = 2  ,\
 BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22 , BYTE * pMaskBuffer = NULL , ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST , double dLifeTime = 0.0  );

////

////

// ##########################################################################################################################################################################################
// #
// # SERIAL PORT I/O FUNCTIONS (RS232/RS485)
// #
// ##########################################################################################################################################################################################
//

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SERIAL_PORT_ENUMERATION)( UINT * pAvailablePortNum , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_SERIAL_PORT)( UINT iPortNum , PVOID * ppPort , ULONG nBaudRate = 9600 , ULONG nDataBits = 8 , ULONG nParityCheck = QCAP_SERIAL_PORT_PARITY_CHECK_NONE , ULONG nStopBits = QCAP_SERIAL_PORT_STOP_BITS_ONE ,\
 ULONG nFlowControl = QCAP_SERIAL_PORT_FLOW_CONTROL_NONE , BOOL bAsynchronousIO = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_SERIAL_PORT)( PVOID pPort  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_SERIAL_PORT)( PVOID pPort  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_SERIAL_PORT)( PVOID pPort  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SEND_SERIAL_PORT_SIGNAL)( PVOID pPort , ULONG nSignalType  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SEND_SERIAL_PORT_DATA)( PVOID pPort , BYTE * pDataBuffer , ULONG nDataBufferLen  );

////

// ##########################################################################################################################################################################################
// #
// # DISC BURNING FUNCTIONS
// #
// ##########################################################################################################################################################################################
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BURNING_DRIVE)( CHAR cDriveName , CHAR * pVolumeName , PVOID * ppDrive  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_BURNING_DRIVE)( PVOID pDrive  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_BURNING_DRIVE)( PVOID pDrive  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_BURNING_DRIVE)( PVOID pDrive  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_UNLOAD_DISC)( PVOID pDrive  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOAD_DISC)( PVOID pDrive  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DISC_INFO)( PVOID pDrive , BOOL * pIsDiscBlank , BOOL * pIsDiscWriteable , DWORD * pDiscType , ULONGLONG * pDiscRemainCapability  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_ERASE_DISC)( PVOID pDrive  );

// BURNING EXAMPLE:
// 
// STEP#01 QCAP_CREATE_BURNING_DRIVE( 'E', "TEST", &pDrive );
//
// STEP#02 QCAP_START_BURNING_DRIVE( pDrive );
// 
// STEP#03 QCAP_START_RECORD( pDevice, 0, "E:\\CH01.TS" );
// 
// STEP#04 QCAP_STOP_RECORD( pDevice, 0, FALSE, INFINE ); // NOTE!! WAITIING FILE CLOSE
// 
// STEP#05 QCAP_STOP_BURNING_DRIVE( pDrive );
// 
// STEP#06 QCAP_UNLOAD_DISC( pDrive );
// 
// STEP#07 QCAP_DESTROY_BURNING_DRIVE( pDrive );

// ##########################################################################################################################################################################################
// #
// # MEDIA TIMER FUNCTIONS (HIGH PRECISION)
// #
// ##########################################################################################################################################################################################
//

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_MEDIA_TIMER)( ULONG nElapseTimeNum , ULONG nElapseTimeDeno , PVOID * ppTimer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_MEDIA_TIMER)( PVOID pTimer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_MEDIA_TIMER)( PVOID pTimer  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_MEDIA_TIMER)( PVOID pTimer  );

////

// ##########################################################################################################################################################################################
// #
// # HELPER FUNCTIONS (ENCODER/VIDEO/AUDIO/DEVELOPER)
// #
// ##########################################################################################################################################################################################
//
// HELPER FUNCTIONS PART.1 (FOR ENCODER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_H264_BUFFER_LAYER_ID)( BYTE * pStreamBuffer , ULONG nStreamBufferLen , ULONG * pLayerID  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_H264_BUFFER_COLOR_INFO)( BYTE * pStreamBuffer , ULONG nStreamBufferLen , ULONG * pColorRangeType  );

// HELPER FUNCTIONS PART.2 (FOR VIDEO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_ABGR32)( BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BYTE bAlpah = 0x00 , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_ABGR32)( BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BYTE bAlpah = 0x00 , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_ARGB32)( BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BYTE bAlpah = 0x00 , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_ARGB32)( BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BYTE bAlpah = 0x00 , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_BGR24)(  BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_BGR24)(  BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_RGB24)(  BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_RGB24)(  BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_YV12)(   BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_YUY2)(   BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight ,\
 ULONG nDstPitch , BOOL bHorizontalMirror = FALSE , BOOL bVerticalMirror = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BUFFER_TO_BMP_EX)( CHAR * pszFilePathName , ULONG nColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , UINT nCropX ,\
 UINT nCropY , UINT nCropW , UINT nCropH , UINT nDstW , UINT nDstH , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0 , BYTE * pszDstStreamBuffer = NULL , ULONG * pDstStreamBufferSize = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BUFFER_TO_JPG_EX)( CHAR * pszFilePathName , ULONG nColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , UINT nCropX ,\
 UINT nCropY , UINT nCropW , UINT nCropH , UINT nDstW , UINT nDstH , ULONG nQuality , BOOL bIsAsync = TRUE , ULONG nMilliseconds = 0 , BYTE * pszDstStreamBuffer = NULL , ULONG * pDstStreamBufferSize = NULL  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CONVERT_3D_STEREO_BUFFER)( ULONG nColorSpaceType , ULONG nSrcStereoDisplayMode , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch ,\
 ULONG nDstStereoDisplayMode , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight , ULONG nDstPitch , BOOL bLeftRightSwap = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESIZE_VIDEO_BUFFER)( ULONG nColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth , ULONG nDstHeight , ULONG nDstPitch  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESIZE_VIDEO_BUFFER_TO_QDEEP_32F)( ULONG nSrcColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , float * pDstFrameBuffer_R ,\
 float * pDstFrameBuffer_G , float * pDstFrameBuffer_B , ULONG nDstWidth , ULONG nDstHeight , ULONG nDstPitch  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY)( ULONG nSrcWidth , ULONG nSrcHeight , ULONG * pDstWidth , ULONG * pDstHeight , double dAngle  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_ROTATE_VIDEO_BUFFER)( ULONG nColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth ,\
 ULONG nDstHeight , ULONG nDstPitch , double dAngle , BYTE * pSrcTempFrameBuffer = NULL , BYTE * pDstTempFrameBuffer = NULL , BOOL bClearBackground = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_WARP_VIDEO_BUFFER)( ULONG nColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , BYTE * pDstFrameBuffer , ULONG nDstWidth ,\
 ULONG nDstHeight , ULONG nDstPitch , LONG nWarpDstX1 , LONG nWarpDstY1 , LONG nWarpDstX2 , LONG nWarpDstY2 , LONG nWarpDstX3 , LONG nWarpDstY3 , LONG nWarpDstX4 , LONG nWarpDstY4 , BYTE * pSrcTempFrameBuffer = NULL , BYTE * pDstTempFrameBuffer = NULL , BOOL bClearBackground = TRUE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOAD_PICTURE_BUFFER)( CHAR * pszFilePathName , ULONG * pColorSpaceType , BYTE * pFrameBuffer , ULONG * pFrameBufferSize , ULONG * pFrameWidth , ULONG * pFrameHeight , ULONG * pFramePitch  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CALCULATE_CHROMAKEY)( ULONG nColorSpaceType , BYTE * pSrcFrameBuffer , ULONG nSrcWidth , ULONG nSrcHeight , ULONG nSrcPitch , ULONG nSrcCropX , ULONG nSrcCropY ,\
 ULONG nSrcCropW , ULONG nSrcCropH , BYTE * pDstAlpahBuffer , BYTE * pDstYBuffer , BYTE * pDstCbBuffer , BYTE * pDstCrBuffer , ULONG nDstWidth , ULONG nDstHeight , ULONG nDstPitch , ULONG nTransparent , DWORD dwKeyColor = 0xFFFFFFFF  , ULONG nKeyColorThreshold = 25  ,\
 ULONG nKeyColorBlurLevel = 2  , BOOL bKeyColorSpillSuppress = TRUE , ULONG nKeyColorSpillSuppressThreshold = 22  );

// HELPER FUNCTIONS PART.3 (FOR AUDIO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_BUFFER_VOLUME_DB)( BYTE * pFrameBuffer , ULONG nFrameBufferLen , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , UINT iChNum , double * pVolumeDB   );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_BUFFER_FAST_FOURIER_TRANSFORM_DATA)( BYTE * pFrameBuffer , ULONG nFrameBufferLen , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , UINT iChNum ,\
 double * pPeakFrq , double * pPeakFrqAmp  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESAMPLE_AUDIO_BUFFER)( BYTE * pSrcFrameBuffer , ULONG nSrcFrameBufferLen , ULONG nSrcChannels , ULONG nSrcBitsPerSample , ULONG nSrcSampleFrequency , BYTE * pDstFrameBuffer ,\
 ULONG * pDstFrameBufferLen , ULONG nDstChannels , ULONG nDstBitsPerSample , ULONG nDstSampleFrequency  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESCALE_AUDIO_BUFFER)( BYTE * pFrameBuffer , ULONG nFrameBufferLen , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , ULONG nVolume  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SOUNDRENDERER_ENUMERATION)( CHAR * * ppszSoundRendererDevName , BOOL bNext = FALSE  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SOUNDRENDERER_ENUMERATION_W)( WSTRING * ppwszSoundRendererDevName , BOOL bNext = FALSE  );

// HELPER FUNCTIONS PART.4 (FOR .NET DEVELOPER) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API ULONGLONG QCAP_EXPORT QCAP_HELPER_OBJPTR( PVOID pObj  );

#define GET_FUNCTION_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_I_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_II_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_III_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_IIII_ADDRESS( HANDLE_NAME );\
		GET_SYSTEM_FUNCTIONS_ADDRESS( HANDLE_NAME );\
		GET_DEVICE_FUNCTIONS_ADDRESS( HANDLE_NAME );\
		GET_LABVIEW_ADDRESS( HANDLE_NAME );\
		GET_SNAPSHOT_ADDRESS( HANDLE_NAME );\
		GET_CHANNEL_RECORDING_ADDRESS( HANDLE_NAME );\
		GET_CLONE_ADDRESS( HANDLE_NAME );\
		GET_OSD_ADDRESS( HANDLE_NAME );\
		GET_MULTIPLE_CHANNELS_ADDRESS( HANDLE_NAME );\
		GET_SHARE_RECORDING_ADDRESS( HANDLE_NAME );\
		QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY( HANDLE_NAME );\
		QCAP_GET_VIDEO_3D_SHARE_RECORDING_PROPERTY( HANDLE_NAME );\
		QCAP_GET_AUDIO_MIXING_SHARE_RECORDING_PROPERTY( HANDLE_NAME );\
		QCAP_GET_BROADCASTING_SERVER_PROPERTY( HANDLE_NAME );\
		QCAP_GET_VIDEO_3D_BROADCASTING_SERVER_PROPERTY( HANDLE_NAME );\
		QCAP_GET_AUDIO_MIXING_BROADCASTING_SERVER_PROPERTY( HANDLE_NAME );\
		QCAP_GET_CREATE_BROADCAST_CLIENT_ADDRESS( HANDLE_NAME );\
		QCAP_GET_3D_BROADCASTING_CLIENT_PROPERTY( HANDLE_NAME );\
		QCAP_GET_COMMUNICATION_SERVER_PROPERTY( HANDLE_NAME );\
		QCAP_GET_COMMUNICATION_ONVIF_EMULATOR_PROPERTY( HANDLE_NAME );\
	QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT( HANDLE_NAME );\
		QCAP_GET_ANIMATION_CLIP_PROPERTY( HANDLE_NAME );\
		QCAP_CREATE_VIRTUAL_CAMERA_PROPERTY( HANDLE_NAME );\
		QCAP_GET_AUDIO_MIXING_VIRTUAL_CAMERA_PROPERTY( HANDLE_NAME );\

#define GET_CALLBACK_FUNCTIONS_I_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FORMAT_CHANGED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FORMAT_CHANGED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX" );\
		(FARPROC &)QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_RECORD_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_RECORD_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_RECORD_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK" );\

#define GET_CALLBACK_FUNCTIONS_II_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK" );\

#define GET_CALLBACK_FUNCTIONS_III_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK" );\

#define GET_CALLBACK_FUNCTIONS_IIII_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_REGISTER_VIDEO_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_MEDIA_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FILE_TRANSCODER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_TRANSCODER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_TIMER_CALLBACK" );\

#define GET_SYSTEM_FUNCTIONS_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_GET_VERSION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VERSION" );\
		(FARPROC &)QCAP_SET_SYSTEM_CONFIGURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_SYSTEM_CONFIGURATION" );\
		(FARPROC &)QCAP_QUERY_ENCODER_TYPE_CAP = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_ENCODER_TYPE_CAP" );\
		(FARPROC &)QCAP_QUERY_DECODER_TYPE_CAP = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_DECODER_TYPE_CAP" );\
		(FARPROC &)QCAP_QUERY_ENCODER_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_ENCODER_STATUS" );\

#define GET_DEVICE_FUNCTIONS_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_DEVICE_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_DEVICE_ENUMERATION" );\
		(FARPROC &)QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO" );\
		(FARPROC &)QCAP_CREATE = GetProcAddress( HANDLE_NAME, "QCAP_CREATE" );\
		(FARPROC &)QCAP_DESTROY = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY" );\
		(FARPROC &)QCAP_RUN = GetProcAddress( HANDLE_NAME, "QCAP_RUN" );\
		(FARPROC &)QCAP_RUN_EX = GetProcAddress( HANDLE_NAME, "QCAP_RUN_EX" );\
		(FARPROC &)QCAP_STOP = GetProcAddress( HANDLE_NAME, "QCAP_STOP" );\
		(FARPROC &)QCAP_QUERY_DEVICE_CAP = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_DEVICE_CAP" );\
		(FARPROC &)QCAP_GET_VIDEO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_INPUT" );\
		(FARPROC &)QCAP_SET_VIDEO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_INPUT" );\
		(FARPROC &)QCAP_GET_AUDIO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_INPUT" );\
		(FARPROC &)QCAP_SET_AUDIO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_INPUT" );\
		(FARPROC &)QCAP_GET_VIDEO_STANDARD = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_STANDARD" );\
		(FARPROC &)QCAP_SET_VIDEO_STANDARD = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_STANDARD" );\
		(FARPROC &)QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS" );\
		(FARPROC &)QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT" );\
		(FARPROC &)QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT_EX" );\
		(FARPROC &)QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT" );\
		(FARPROC &)QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT" );\
		(FARPROC &)QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT" );\
		(FARPROC &)QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT" );\
		(FARPROC &)QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT" );\
		(FARPROC &)QCAP_GET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES" );\
		(FARPROC &)QCAP_SET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES" );\
		(FARPROC &)QCAP_GET_VIDEO_DEINTERLACE_TYPE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_DEINTERLACE_TYPE" );\
		(FARPROC &)QCAP_SET_VIDEO_DEINTERLACE_TYPE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_DEINTERLACE_TYPE" );\
		(FARPROC &)QCAP_GET_VIDEO_DEINTERLACE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_DEINTERLACE" );\
		(FARPROC &)QCAP_SET_VIDEO_DEINTERLACE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_DEINTERLACE" );\
		(FARPROC &)QCAP_GET_VIDEO_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_REGION_DISPLAY" );\
		(FARPROC &)QCAP_SET_VIDEO_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_REGION_DISPLAY" );\
		(FARPROC &)QCAP_GET_VIDEO_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_MIRROR" );\
		(FARPROC &)QCAP_SET_VIDEO_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_MIRROR" );\
		(FARPROC &)QCAP_GET_VIDEO_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BRIGHTNESS" );\
		(FARPROC &)QCAP_SET_VIDEO_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BRIGHTNESS" );\
		(FARPROC &)QCAP_GET_VIDEO_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CONTRAST" );\
		(FARPROC &)QCAP_SET_VIDEO_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_CONTRAST" );\
		(FARPROC &)QCAP_GET_VIDEO_HUE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HUE" );\
		(FARPROC &)QCAP_SET_VIDEO_HUE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HUE" );\
		(FARPROC &)QCAP_GET_VIDEO_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SATURATION" );\
		(FARPROC &)QCAP_SET_VIDEO_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SATURATION" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARPNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARPNESS" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARPNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARPNESS" );\
		(FARPROC &)QCAP_GET_VIDEO_BRIGHTNESS_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BRIGHTNESS_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_BRIGHTNESS_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BRIGHTNESS_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_CONTRAST_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CONTRAST_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_CONTRAST_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_CONTRAST_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_HUE_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HUE_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_HUE_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HUE_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_SATURATION_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SATURATION_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_SATURATION_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SATURATION_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARPNESS_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARPNESS_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARPNESS_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARPNESS_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY" );\
		(FARPROC &)QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY" );\
		(FARPROC &)QCAP_GET_AUDIO_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SOUND_RENDERER" );\
		(FARPROC &)QCAP_SET_AUDIO_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SOUND_RENDERER" );\
		(FARPROC &)QCAP_GET_AUDIO_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_VOLUME" );\
		(FARPROC &)QCAP_SET_AUDIO_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VOLUME" );\
		(FARPROC &)QCAP_GET_DEVICE_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_DEVICE_CUSTOM_PROPERTY" );\
		(FARPROC &)QCAP_SET_DEVICE_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEVICE_CUSTOM_PROPERTY" );\
		(FARPROC &)QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX" );\
		(FARPROC &)QCAP_DIAGNOSE_VIDEO_STREAM_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_DIAGNOSE_VIDEO_STREAM_STATUS" );\
		(FARPROC &)QCAP_DIAGNOSE_AUDIO_STREAM_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_DIAGNOSE_AUDIO_STREAM_STATUS" );\
		(FARPROC &)QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FORMAT_CHANGED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FORMAT_CHANGED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK" );\

#define GET_LABVIEW_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_COPY_VIDEO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_COPY_VIDEO_PREVIEW_BUFFER" );\
		(FARPROC &)QCAP_COPY_AUDIO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_COPY_AUDIO_PREVIEW_BUFFER" );\
		(FARPROC &)QCAP_LOCK_VIDEO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_LOCK_VIDEO_PREVIEW_BUFFER" );\
		(FARPROC &)QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER" );\
		(FARPROC &)QCAP_LOCK_AUDIO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_LOCK_AUDIO_PREVIEW_BUFFER" );\
		(FARPROC &)QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER" );\

#define GET_SNAPSHOT_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_SNAPSHOT_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BMP" );\
		(FARPROC &)QCAP_SNAPSHOT_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_JPG" );\
		(FARPROC &)QCAP_SNAPSHOT_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_JPG_EX" );\
		(FARPROC &)QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK" );\

#define GET_CHANNEL_RECORDING_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_GET_VIDEO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_GET_VIDEO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_AUDIO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_SET_AUDIO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_GET_AUDIO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_METADATA_RECORD_HEADER = GetProcAddress( HANDLE_NAME, "QCAP_SET_METADATA_RECORD_HEADER" );\
		(FARPROC &)QCAP_SET_METADATA_RECORD_HEADER_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_METADATA_RECORD_HEADER_W" );\
		(FARPROC &)QCAP_SET_METADATA_RECORD_DATA_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_METADATA_RECORD_DATA_BUFFER" );\
		(FARPROC &)QCAP_START_CLONE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_CLONE_RECORD" );\
		(FARPROC &)QCAP_START_TIMESHIFT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_TIMESHIFT_RECORD" );\
		(FARPROC &)QCAP_START_FAILSAFE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_FAILSAFE_RECORD" );\
		(FARPROC &)QCAP_START_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_RECORD" );\
		(FARPROC &)QCAP_STOP_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_RECORD" );\
		(FARPROC &)QCAP_RESUME_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_RECORD" );\
		(FARPROC &)QCAP_PAUSE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_RECORD" );\
		(FARPROC &)QCAP_REGISTER_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_RECORD_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_RECORD_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_RECORD_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_MEDIA_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_RECORD_CALLBACK" );\

#define GET_CLONE_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_CLONE = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_CLONE" );\

#define GET_OSD_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_MOVE_OSD_OBJECT = GetProcAddress( HANDLE_NAME, "QCAP_MOVE_OSD_OBJECT" );\
		(FARPROC &)QCAP_GET_OSD_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_TEXT_BOUNDARY" );\
		(FARPROC &)QCAP_GET_OSD_TEXT_BOUNDARY_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_TEXT_BOUNDARY_W" );\
		(FARPROC &)QCAP_SET_OSD_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_TEXT" );\
		(FARPROC &)QCAP_SET_OSD_TEXT_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_TEXT_W" );\
		(FARPROC &)QCAP_SET_OSD_TEXT_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_TEXT_EX" );\
		(FARPROC &)QCAP_SET_OSD_TEXT_EX_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_TEXT_EX_W" );\
		(FARPROC &)QCAP_SET_OSD_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_PICTURE" );\
		(FARPROC &)QCAP_SET_OSD_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BUFFER" );\
		(FARPROC &)QCAP_SET_OSD_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BUFFER_EX" );\
		(FARPROC &)QCAP_CREATE_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_SYNCHRONIZED_RECORD" );\
		(FARPROC &)QCAP_DESTROY_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_SYNCHRONIZED_RECORD" );\

#define GET_MULTIPLE_CHANNELS_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_START_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_SYNCHRONIZED_RECORD" );\
		(FARPROC &)QCAP_STOP_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_SYNCHRONIZED_RECORD" );\
		(FARPROC &)QCAP_RESUME_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_SYNCHRONIZED_RECORD" );\
		(FARPROC &)QCAP_PAUSE_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_SYNCHRONIZED_RECORD" );\
		(FARPROC &)QCAP_CAMERA_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_CAMERA_ENUMERATION" );\
		(FARPROC &)QCAP_CAMERA_ENUMERATION_W = GetProcAddress( HANDLE_NAME, "QCAP_CAMERA_ENUMERATION_W" );\
		(FARPROC &)QCAP_SET_DEFAULT_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEFAULT_CAMERA" );\
		(FARPROC &)QCAP_GET_CAMERA_COUNT_OF_SUPPORT_OUTPUT_FORMATS = GetProcAddress( HANDLE_NAME, "QCAP_GET_CAMERA_COUNT_OF_SUPPORT_OUTPUT_FORMATS" );\
		(FARPROC &)QCAP_GET_CAMERA_SUPPORT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_CAMERA_SUPPORT_OUTPUT_FORMAT" );\
		(FARPROC &)QCAP_SOUNDCARD_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_SOUNDCARD_ENUMERATION" );\
		(FARPROC &)QCAP_SOUNDCARD_ENUMERATION_W = GetProcAddress( HANDLE_NAME, "QCAP_SOUNDCARD_ENUMERATION_W" );\
		(FARPROC &)QCAP_SET_DEFAULT_SOUNDCARD = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEFAULT_SOUNDCARD" );\
		(FARPROC &)QCAP_GET_SHARE_RECORD_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_GET_SHARE_RECORD_STATUS" );\

#define GET_SHARE_RECORDING_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY" );\

#define QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_COPP = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_COPP" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_COPP = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_COPP" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_BRIGHTNESS" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_BRIGHTNESS" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_CONTRAST" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_CONTRAST" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_HUE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_HUE" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_HUE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_HUE" );\
		(FARPROC &)QCAP_GET_VIDEO_SHARE_RECORD_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_SATURATION" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_SATURATION" );\
		(FARPROC &)QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY" );\
		(FARPROC &)QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_AUDIO_SHARE_RECORD_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SHARE_RECORD_SOUND_RENDERER" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_SOUND_RENDERER" );\
		(FARPROC &)QCAP_GET_AUDIO_SHARE_RECORD_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SHARE_RECORD_VOLUME" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_VOLUME" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_METADATA_SHARE_RECORD_HEADER = GetProcAddress( HANDLE_NAME, "QCAP_SET_METADATA_SHARE_RECORD_HEADER" );\
		(FARPROC &)QCAP_SET_METADATA_SHARE_RECORD_HEADER_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_METADATA_SHARE_RECORD_HEADER_W" );\
		(FARPROC &)QCAP_SET_METADATA_SHARE_RECORD_DATA_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_METADATA_SHARE_RECORD_DATA_BUFFER" );\
		(FARPROC &)QCAP_START_TIMESHIFT_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_TIMESHIFT_SHARE_RECORD" );\
		(FARPROC &)QCAP_START_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_SHARE_RECORD" );\
		(FARPROC &)QCAP_STOP_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_SHARE_RECORD" );\
		(FARPROC &)QCAP_RESUME_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_SHARE_RECORD" );\
		(FARPROC &)QCAP_PAUSE_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_SHARE_RECORD" );\
		(FARPROC &)QCAP_SNAPSHOT_SHARE_RECORD_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_BMP" );\
		(FARPROC &)QCAP_SNAPSHOT_SHARE_RECORD_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_JPG" );\
		(FARPROC &)QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX" );\
		(FARPROC &)QCAP_MOVE_OSD_SHARE_RECORD_OBJECT = GetProcAddress( HANDLE_NAME, "QCAP_MOVE_OSD_SHARE_RECORD_OBJECT" );\
		(FARPROC &)QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY" );\
		(FARPROC &)QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY_W" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_TEXT" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_TEXT_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_TEXT_W" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_TEXT_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_TEXT_EX" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_TEXT_EX_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_TEXT_EX_W" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_PICTURE" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_BUFFER" );\
		(FARPROC &)QCAP_SET_OSD_SHARE_RECORD_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_BUFFER_EX" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK" );\

#define QCAP_GET_VIDEO_3D_SHARE_RECORDING_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\

#define QCAP_GET_AUDIO_MIXING_SHARE_RECORDING_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK" );\
		(FARPROC &)QCAP_GET_BROADCAST_SERVER_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_GET_BROADCAST_SERVER_STATUS" );\

#define QCAP_GET_BROADCASTING_SERVER_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_BROADCAST_RTSP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTSP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_RTSP_RAW_UDP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTSP_RAW_UDP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_HLS_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_HLS_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_RTMP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_RTMP_SERVER_EX = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_SERVER_EX" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_TS_OVER_TCP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_TS_OVER_TCP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_TS_OVER_HTTP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_TS_OVER_HTTP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_TS_OVER_RTP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_TS_OVER_RTP_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_TS_OVER_TCP_PASSIVE_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_TS_OVER_TCP_PASSIVE_SERVER" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_NDI_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_NDI_SERVER" );\
		(FARPROC &)QCAP_DESTROY_BROADCAST_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_BROADCAST_SERVER" );\
		(FARPROC &)QCAP_START_BROADCAST_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_SERVER" );\
		(FARPROC &)QCAP_STOP_BROADCAST_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BROADCAST_SERVER" );\
		(FARPROC &)QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE" );\
		(FARPROC &)QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX" );\
		(FARPROC &)QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY" );\
		(FARPROC &)QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_SERVER_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_VOLUME" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_VOLUME" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_SERVER_NETWORK_QOS_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_NETWORK_QOS_STATUS" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_SERVER_NETWORK_QOS_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_NETWORK_QOS_STATUS" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER" );\

#define QCAP_GET_VIDEO_3D_BROADCASTING_SERVER_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\

#define QCAP_GET_AUDIO_MIXING_BROADCASTING_SERVER_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_COMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_CLEAR_VIDEO_BROADCAST_SERVER_DELAY_LIVE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_CLEAR_VIDEO_BROADCAST_SERVER_DELAY_LIVE_BUFFER" );\
		(FARPROC &)QCAP_CLEAR_AUDIO_BROADCAST_SERVER_DELAY_LIVE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_CLEAR_AUDIO_BROADCAST_SERVER_DELAY_LIVE_BUFFER" );\
		(FARPROC &)QCAP_CLEAR_AUDIO_MX_BROADCAST_SERVER_DELAY_LIVE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_CLEAR_AUDIO_MX_BROADCAST_SERVER_DELAY_LIVE_BUFFER" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_SERVER_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_BMP" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_SERVER_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_JPG" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX" );\
		(FARPROC &)QCAP_MOVE_OSD_BROADCAST_SERVER_OBJECT = GetProcAddress( HANDLE_NAME, "QCAP_MOVE_OSD_BROADCAST_SERVER_OBJECT" );\
		(FARPROC &)QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY" );\
		(FARPROC &)QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY_W" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_TEXT" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_TEXT_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_TEXT_W" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX_W" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_PICTURE" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_BUFFER" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_SERVER_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_BUFFER_EX" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK" );\

#define QCAP_GET_CREATE_BROADCAST_CLIENT_ADDRESS( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_CLIENT" );\
		(FARPROC &)QCAP_CREATE_BROADCAST_CLIENT_EX = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_CLIENT_EX" );\

#define QCAP_GET_3D_BROADCASTING_CLIENT_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_3D_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_3D_BROADCAST_CLIENT" );\
		(FARPROC &)QCAP_CREATE_3D_BROADCAST_CLIENT_EX = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_3D_BROADCAST_CLIENT_EX" );\
		(FARPROC &)QCAP_DESTROY_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_BROADCAST_CLIENT" );\
		(FARPROC &)QCAP_START_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_CLIENT" );\
		(FARPROC &)QCAP_START_BROADCAST_CLIENT_EX = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_CLIENT_EX" );\
		(FARPROC &)QCAP_STOP_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BROADCAST_CLIENT" );\
		(FARPROC &)QCAP_GET_BROADCAST_CLIENT_OUTPUT_STREAMS = GetProcAddress( HANDLE_NAME, "QCAP_GET_BROADCAST_CLIENT_OUTPUT_STREAMS" );\
		(FARPROC &)QCAP_SET_BROADCAST_CLIENT_OUTPUT_STREAMS = GetProcAddress( HANDLE_NAME, "QCAP_SET_BROADCAST_CLIENT_OUTPUT_STREAMS" );\
		(FARPROC &)QCAP_DIAGNOSE_VIDEO_BROADCAST_CLIENT_STREAM_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_DIAGNOSE_VIDEO_BROADCAST_CLIENT_STREAM_STATUS" );\
		(FARPROC &)QCAP_DIAGNOSE_AUDIO_BROADCAST_CLIENT_STREAM_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_DIAGNOSE_AUDIO_BROADCAST_CLIENT_STREAM_STATUS" );\
		(FARPROC &)QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_CONTRAST" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_CONTRAST" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_HUE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_HUE" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_HUE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_HUE" );\
		(FARPROC &)QCAP_GET_VIDEO_BROADCAST_CLIENT_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_SATURATION" );\
		(FARPROC &)QCAP_SET_VIDEO_BROADCAST_CLIENT_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_SATURATION" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER" );\
		(FARPROC &)QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME" );\
		(FARPROC &)QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME" );\
		(FARPROC &)QCAP_START_BROADCAST_CLIENT_TIMESHIFT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_CLIENT_TIMESHIFT_RECORD" );\
		(FARPROC &)QCAP_START_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_CLIENT_RECORD" );\
		(FARPROC &)QCAP_STOP_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BROADCAST_CLIENT_RECORD" );\
		(FARPROC &)QCAP_RESUME_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_BROADCAST_CLIENT_RECORD" );\
		(FARPROC &)QCAP_PAUSE_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_BROADCAST_CLIENT_RECORD" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX" );\
		(FARPROC &)QCAP_MOVE_OSD_BROADCAST_CLIENT_OBJECT = GetProcAddress( HANDLE_NAME, "QCAP_MOVE_OSD_BROADCAST_CLIENT_OBJECT" );\
		(FARPROC &)QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY" );\
		(FARPROC &)QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY_W" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_TEXT" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_W" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX_W" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER" );\
		(FARPROC &)QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER_EX" );\
		(FARPROC &)QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY" );\
		(FARPROC &)QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK" );\

#define QCAP_GET_COMMUNICATION_SERVER_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_COMMUNICATION_ONVIF_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_COMMUNICATION_ONVIF_SERVER" );\
		(FARPROC &)QCAP_DESTROY_COMMUNICATION_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_COMMUNICATION_SERVER" );\
		(FARPROC &)QCAP_START_COMMUNICATION_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_START_COMMUNICATION_SERVER" );\
		(FARPROC &)QCAP_STOP_COMMUNICATION_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_STOP_COMMUNICATION_SERVER" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_SERVER_PROFILE = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_PROFILE" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_SERVER_PROFILE = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_PROFILE" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK" );\

#define QCAP_GET_COMMUNICATION_ONVIF_EMULATOR_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR" );\
		(FARPROC &)QCAP_DESTROY_COMMUNICATION_EMULATOR = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_COMMUNICATION_EMULATOR" );\
		(FARPROC &)QCAP_START_COMMUNICATION_EMULATOR = GetProcAddress( HANDLE_NAME, "QCAP_START_COMMUNICATION_EMULATOR" );\
		(FARPROC &)QCAP_STOP_COMMUNICATION_EMULATOR = GetProcAddress( HANDLE_NAME, "QCAP_STOP_COMMUNICATION_EMULATOR" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK" );\

#define QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT" );\
		(FARPROC &)QCAP_DESTROY_COMMUNICATION_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_COMMUNICATION_CLIENT" );\
		(FARPROC &)QCAP_START_COMMUNICATION_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_START_COMMUNICATION_CLIENT" );\
		(FARPROC &)QCAP_STOP_COMMUNICATION_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_STOP_COMMUNICATION_CLIENT" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_VIDEO_SOURCE_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_VIDEO_SOURCE_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_AUDIO_SOURCE_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_AUDIO_SOURCE_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_OPTION_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_OPTION_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_OPTION_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_OPTION_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_PROFILE_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_PROFILE_INFO" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY" );\
		(FARPROC &)QCAP_GET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY" );\
		(FARPROC &)QCAP_SET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY" );\
		(FARPROC &)QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_CREATE_WEBRTC_CHATROOM = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_WEBRTC_CHATROOM" );\
		(FARPROC &)QCAP_DESTROY_WEBRTC_CHATROOM = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_WEBRTC_CHATROOM" );\
		(FARPROC &)QCAP_CREATE_WEBRTC_CHATTER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_WEBRTC_CHATTER" );\
		(FARPROC &)QCAP_DESTROY_WEBRTC_CHATTER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_WEBRTC_CHATTER" );\
		(FARPROC &)QCAP_START_WEBRTC_CHAT = GetProcAddress( HANDLE_NAME, "QCAP_START_WEBRTC_CHAT" );\
		(FARPROC &)QCAP_STOP_WEBRTC_CHAT = GetProcAddress( HANDLE_NAME, "QCAP_STOP_WEBRTC_CHAT" );\
		(FARPROC &)QCAP_CREATE_WEBRTC_SENDER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_WEBRTC_SENDER" );\
		(FARPROC &)QCAP_CREATE_WEBRTC_RECEIVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_WEBRTC_RECEIVER" );\
		(FARPROC &)QCAP_SET_WEBRTC_PRIVATE_SDP_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_WEBRTC_PRIVATE_SDP_PROPERTY" );\
		(FARPROC &)QCAP_ENUM_WEBRTC_USER_IN_CHATROOM = GetProcAddress( HANDLE_NAME, "QCAP_ENUM_WEBRTC_USER_IN_CHATROOM" );\
		(FARPROC &)QCAP_SEND_WEBRTC_DATA = GetProcAddress( HANDLE_NAME, "QCAP_SEND_WEBRTC_DATA" );\
		(FARPROC &)QCAP_SEND_WEBRTC_FILE = GetProcAddress( HANDLE_NAME, "QCAP_SEND_WEBRTC_FILE" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK" );\
		(FARPROC &)QCAP_OPEN_FILE = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_FILE" );\
		(FARPROC &)QCAP_OPEN_FILE_EX = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_FILE_EX" );\
		(FARPROC &)QCAP_OPEN_3D_FILE = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_3D_FILE" );\
		(FARPROC &)QCAP_OPEN_TIMESHIFT_FILE_EX = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_TIMESHIFT_FILE_EX" );\
		(FARPROC &)QCAP_OPEN_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_SCF_FILE" );\
		(FARPROC &)QCAP_DESTROY_FILE = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_FILE" );\
		(FARPROC &)QCAP_PLAY_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PLAY_FILE" );\
		(FARPROC &)QCAP_PAUSE_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_FILE" );\
		(FARPROC &)QCAP_STOP_FILE = GetProcAddress( HANDLE_NAME, "QCAP_STOP_FILE" );\
		(FARPROC &)QCAP_PLAY_GLOBAL_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PLAY_GLOBAL_SCF_FILE" );\
		(FARPROC &)QCAP_PAUSE_GLOBAL_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_GLOBAL_SCF_FILE" );\
		(FARPROC &)QCAP_STOP_GLOBAL_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_STOP_GLOBAL_SCF_FILE" );\
		(FARPROC &)QCAP_REFRESH_TIMESHIFT_FILE_INFO = GetProcAddress( HANDLE_NAME, "QCAP_REFRESH_TIMESHIFT_FILE_INFO" );\
		(FARPROC &)QCAP_SCF_FILE_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_SCF_FILE_ENUMERATION" );\
		(FARPROC &)QCAP_SET_SCF_FILE_TIMER = GetProcAddress( HANDLE_NAME, "QCAP_SET_SCF_FILE_TIMER" );\
		(FARPROC &)QCAP_GET_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_GET_FILE_POSITION" );\
		(FARPROC &)QCAP_SET_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_SET_FILE_POSITION" );\
		(FARPROC &)QCAP_GET_FILE_POSITION_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_FILE_POSITION_EX" );\
		(FARPROC &)QCAP_SET_FILE_POSITION_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_FILE_POSITION_EX" );\
		(FARPROC &)QCAP_GET_GLOBAL_SCF_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_GET_GLOBAL_SCF_FILE_POSITION" );\
		(FARPROC &)QCAP_SET_GLOBAL_SCF_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_SET_GLOBAL_SCF_FILE_POSITION" );\
		(FARPROC &)QCAP_GET_FILE_PLAYBACK_SPEED = GetProcAddress( HANDLE_NAME, "QCAP_GET_FILE_PLAYBACK_SPEED" );\
		(FARPROC &)QCAP_SET_FILE_PLAYBACK_SPEED = GetProcAddress( HANDLE_NAME, "QCAP_SET_FILE_PLAYBACK_SPEED" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_STREAM_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_STREAM_BUFFER" );\
		(FARPROC &)QCAP_GET_AUDIO_FILE_STREAM_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_FILE_STREAM_BUFFER" );\
		(FARPROC &)QCAP_GET_METADATA_FILE_DATA_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_GET_METADATA_FILE_DATA_BUFFER" );\
		(FARPROC &)QCAP_GET_METADATA_FILE_HEADER = GetProcAddress( HANDLE_NAME, "QCAP_GET_METADATA_FILE_HEADER" );\
		(FARPROC &)QCAP_GET_METADATA_FILE_HEADER_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_METADATA_FILE_HEADER_W" );\
		(FARPROC &)QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE" );\
		(FARPROC &)QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_REGION_DISPLAY" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_REGION_DISPLAY" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_MIRROR" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_MIRROR" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_BRIGHTNESS" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_BRIGHTNESS" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_CONTRAST" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_CONTRAST" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_HUE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_HUE" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_HUE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_HUE" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_SATURATION" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_SATURATION" );\
		(FARPROC &)QCAP_GET_AUDIO_FILE_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_FILE_SOUND_RENDERER" );\
		(FARPROC &)QCAP_SET_AUDIO_FILE_SOUND_RENDERER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_FILE_SOUND_RENDERER" );\
		(FARPROC &)QCAP_GET_AUDIO_FILE_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_FILE_VOLUME" );\
		(FARPROC &)QCAP_SET_AUDIO_FILE_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_FILE_VOLUME" );\
		(FARPROC &)QCAP_SNAPSHOT_FILE_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_BMP" );\
		(FARPROC &)QCAP_SNAPSHOT_FILE_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_JPG" );\
		(FARPROC &)QCAP_SNAPSHOT_FILE_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_FILE_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_JPG_EX" );\
		(FARPROC &)QCAP_MOVE_OSD_FILE_OBJECT = GetProcAddress( HANDLE_NAME, "QCAP_MOVE_OSD_FILE_OBJECT" );\
		(FARPROC &)QCAP_GET_OSD_FILE_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_FILE_TEXT_BOUNDARY" );\
		(FARPROC &)QCAP_GET_OSD_FILE_TEXT_BOUNDARY_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_FILE_TEXT_BOUNDARY_W" );\
		(FARPROC &)QCAP_SET_OSD_FILE_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_TEXT" );\
		(FARPROC &)QCAP_SET_OSD_FILE_TEXT_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_TEXT_W" );\
		(FARPROC &)QCAP_SET_OSD_FILE_TEXT_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_TEXT_EX" );\
		(FARPROC &)QCAP_SET_OSD_FILE_TEXT_EX_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_TEXT_EX_W" );\
		(FARPROC &)QCAP_SET_OSD_FILE_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_PICTURE" );\
		(FARPROC &)QCAP_SET_OSD_FILE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_BUFFER" );\
		(FARPROC &)QCAP_SET_OSD_FILE_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_BUFFER_EX" );\
		(FARPROC &)QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX" );\
		(FARPROC &)QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX" );\
		(FARPROC &)QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK" );\
		(FARPROC &)QCAP_EXPORT_FILE = GetProcAddress( HANDLE_NAME, "QCAP_EXPORT_FILE" );\
		(FARPROC &)QCAP_EXPORT_FILE_EX = GetProcAddress( HANDLE_NAME, "QCAP_EXPORT_FILE_EX" );\
		(FARPROC &)QCAP_EXPORT_FILE_EX_C = GetProcAddress( HANDLE_NAME, "QCAP_EXPORT_FILE_EX_C" );\
		(FARPROC &)QCAP_EXPORT_FILES_EX = GetProcAddress( HANDLE_NAME, "QCAP_EXPORT_FILES_EX" );\
		(FARPROC &)QCAP_EXPORT_FILES_EX_C = GetProcAddress( HANDLE_NAME, "QCAP_EXPORT_FILES_EX_C" );\
		(FARPROC &)QCAP_MERGE_FILES = GetProcAddress( HANDLE_NAME, "QCAP_MERGE_FILES" );\
		(FARPROC &)QCAP_MERGE_FILES_EX = GetProcAddress( HANDLE_NAME, "QCAP_MERGE_FILES_EX" );\
		(FARPROC &)QCAP_MERGE_FILES_EX_C = GetProcAddress( HANDLE_NAME, "QCAP_MERGE_FILES_EX_C" );\
		(FARPROC &)QCAP_MERGE_FILES_BY_EDL = GetProcAddress( HANDLE_NAME, "QCAP_MERGE_FILES_BY_EDL" );\
		(FARPROC &)QCAP_BUILD_VIDEO_ON_DEMAND_FILE = GetProcAddress( HANDLE_NAME, "QCAP_BUILD_VIDEO_ON_DEMAND_FILE" );\
		(FARPROC &)QCAP_DIAGNOSE_FILE = GetProcAddress( HANDLE_NAME, "QCAP_DIAGNOSE_FILE" );\
		(FARPROC &)QCAP_REPAIR_FILE = GetProcAddress( HANDLE_NAME, "QCAP_REPAIR_FILE" );\
		(FARPROC &)QCAP_CREATE_FILE_TRANSCODER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_FILE_TRANSCODER" );\
		(FARPROC &)QCAP_DESTROY_FILE_TRANSCODER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_FILE_TRANSCODER" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY" );\
		(FARPROC &)QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY_EX" );\
		(FARPROC &)QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY_EX" );\
		(FARPROC &)QCAP_START_FILE_TRANSCODER = GetProcAddress( HANDLE_NAME, "QCAP_START_FILE_TRANSCODER" );\
		(FARPROC &)QCAP_STOP_FILE_TRANSCODER = GetProcAddress( HANDLE_NAME, "QCAP_STOP_FILE_TRANSCODER" );\
		(FARPROC &)QCAP_REGISTER_FILE_TRANSCODER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_TRANSCODER_CALLBACK" );\

#define QCAP_GET_ANIMATION_CLIP_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_ANIMATION_CLIP" );\
		(FARPROC &)QCAP_DESTROY_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_ANIMATION_CLIP" );\
		(FARPROC &)QCAP_START_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_START_ANIMATION_CLIP" );\
		(FARPROC &)QCAP_STOP_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_STOP_ANIMATION_CLIP" );\
		(FARPROC &)QCAP_STEP_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_STEP_ANIMATION_CLIP" );\
		(FARPROC &)QCAP_SEEK_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_SEEK_ANIMATION_CLIP" );\
		(FARPROC &)QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY" );\
		(FARPROC &)QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE" );\
		(FARPROC &)QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX" );\

#define QCAP_CREATE_VIRTUAL_CAMERA_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_CREATE_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_VIRTUAL_CAMERA" );\
		(FARPROC &)QCAP_DESTROY_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_VIRTUAL_CAMERA" );\
		(FARPROC &)QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY" );\
		(FARPROC &)QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY" );\
		(FARPROC &)QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY" );\
		(FARPROC &)QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX" );\

#define QCAP_GET_AUDIO_MIXING_VIRTUAL_CAMERA_PROPERTY( HANDLE_NAME )\
		(FARPROC &)QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER_EX" );\
		(FARPROC &)QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER" );\
		(FARPROC &)QCAP_START_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_START_VIRTUAL_CAMERA" );\
		(FARPROC &)QCAP_STOP_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_STOP_VIRTUAL_CAMERA" );\
		(FARPROC &)QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP" );\
		(FARPROC &)QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG" );\
		(FARPROC &)QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX" );\
		(FARPROC &)QCAP_MOVE_OSD_VIRTUAL_CAMERA_OBJECT = GetProcAddress( HANDLE_NAME, "QCAP_MOVE_OSD_VIRTUAL_CAMERA_OBJECT" );\
		(FARPROC &)QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY" );\
		(FARPROC &)QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY_W = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY_W" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_W" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX_W = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX_W" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER" );\
		(FARPROC &)QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER_EX" );\
		(FARPROC &)QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK" );\
		(FARPROC &)QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK" );\
		(FARPROC &)QCAP_SERIAL_PORT_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_SERIAL_PORT_ENUMERATION" );\
		(FARPROC &)QCAP_CREATE_SERIAL_PORT = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_SERIAL_PORT" );\
		(FARPROC &)QCAP_DESTROY_SERIAL_PORT = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_SERIAL_PORT" );\
		(FARPROC &)QCAP_START_SERIAL_PORT = GetProcAddress( HANDLE_NAME, "QCAP_START_SERIAL_PORT" );\
		(FARPROC &)QCAP_STOP_SERIAL_PORT = GetProcAddress( HANDLE_NAME, "QCAP_STOP_SERIAL_PORT" );\
		(FARPROC &)QCAP_SEND_SERIAL_PORT_SIGNAL = GetProcAddress( HANDLE_NAME, "QCAP_SEND_SERIAL_PORT_SIGNAL" );\
		(FARPROC &)QCAP_SEND_SERIAL_PORT_DATA = GetProcAddress( HANDLE_NAME, "QCAP_SEND_SERIAL_PORT_DATA" );\
		(FARPROC &)QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK" );\
		(FARPROC &)QCAP_CREATE_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BURNING_DRIVE" );\
		(FARPROC &)QCAP_DESTROY_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_BURNING_DRIVE" );\
		(FARPROC &)QCAP_START_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_START_BURNING_DRIVE" );\
		(FARPROC &)QCAP_STOP_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BURNING_DRIVE" );\
		(FARPROC &)QCAP_UNLOAD_DISC = GetProcAddress( HANDLE_NAME, "QCAP_UNLOAD_DISC" );\
		(FARPROC &)QCAP_LOAD_DISC = GetProcAddress( HANDLE_NAME, "QCAP_LOAD_DISC" );\
		(FARPROC &)QCAP_GET_DISC_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_DISC_INFO" );\
		(FARPROC &)QCAP_ERASE_DISC = GetProcAddress( HANDLE_NAME, "QCAP_ERASE_DISC" );\
		(FARPROC &)QCAP_CREATE_MEDIA_TIMER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_MEDIA_TIMER" );\
		(FARPROC &)QCAP_DESTROY_MEDIA_TIMER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_MEDIA_TIMER" );\
		(FARPROC &)QCAP_START_MEDIA_TIMER = GetProcAddress( HANDLE_NAME, "QCAP_START_MEDIA_TIMER" );\
		(FARPROC &)QCAP_STOP_MEDIA_TIMER = GetProcAddress( HANDLE_NAME, "QCAP_STOP_MEDIA_TIMER" );\
		(FARPROC &)QCAP_REGISTER_MEDIA_TIMER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_TIMER_CALLBACK" );\
		(FARPROC &)QCAP_GET_H264_BUFFER_LAYER_ID = GetProcAddress( HANDLE_NAME, "QCAP_GET_H264_BUFFER_LAYER_ID" );\
		(FARPROC &)QCAP_GET_H264_BUFFER_COLOR_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_H264_BUFFER_COLOR_INFO" );\
		(FARPROC &)QCAP_COLORSPACE_YUY2_TO_ABGR32 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_ABGR32" );\
		(FARPROC &)QCAP_COLORSPACE_YV12_TO_ABGR32 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_ABGR32" );\
		(FARPROC &)QCAP_COLORSPACE_YUY2_TO_ARGB32 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_ARGB32" );\
		(FARPROC &)QCAP_COLORSPACE_YV12_TO_ARGB32 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_ARGB32" );\
		(FARPROC &)QCAP_COLORSPACE_YUY2_TO_BGR24 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_BGR24" );\
		(FARPROC &)QCAP_COLORSPACE_YV12_TO_BGR24 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_BGR24" );\
		(FARPROC &)QCAP_COLORSPACE_YUY2_TO_RGB24 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_RGB24" );\
		(FARPROC &)QCAP_COLORSPACE_YV12_TO_RGB24 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_RGB24" );\
		(FARPROC &)QCAP_COLORSPACE_YUY2_TO_YV12 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_YV12" );\
		(FARPROC &)QCAP_COLORSPACE_YV12_TO_YUY2 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_YUY2" );\
		(FARPROC &)QCAP_SNAPSHOT_BUFFER_TO_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BUFFER_TO_BMP_EX" );\
		(FARPROC &)QCAP_SNAPSHOT_BUFFER_TO_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BUFFER_TO_JPG_EX" );\
		(FARPROC &)QCAP_CONVERT_3D_STEREO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_CONVERT_3D_STEREO_BUFFER" );\
		(FARPROC &)QCAP_RESIZE_VIDEO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_RESIZE_VIDEO_BUFFER" );\
		(FARPROC &)QCAP_RESIZE_VIDEO_BUFFER_TO_QDEEP_32F = GetProcAddress( HANDLE_NAME, "QCAP_RESIZE_VIDEO_BUFFER_TO_QDEEP_32F" );\
		(FARPROC &)QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY" );\
		(FARPROC &)QCAP_ROTATE_VIDEO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_ROTATE_VIDEO_BUFFER" );\
		(FARPROC &)QCAP_WARP_VIDEO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_WARP_VIDEO_BUFFER" );\
		(FARPROC &)QCAP_LOAD_PICTURE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_LOAD_PICTURE_BUFFER" );\
		(FARPROC &)QCAP_CALCULATE_CHROMAKEY = GetProcAddress( HANDLE_NAME, "QCAP_CALCULATE_CHROMAKEY" );\
		(FARPROC &)QCAP_GET_AUDIO_BUFFER_VOLUME_DB = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BUFFER_VOLUME_DB" );\
		(FARPROC &)QCAP_GET_AUDIO_BUFFER_FAST_FOURIER_TRANSFORM_DATA = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BUFFER_FAST_FOURIER_TRANSFORM_DATA" );\
		(FARPROC &)QCAP_RESAMPLE_AUDIO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_RESAMPLE_AUDIO_BUFFER" );\
		(FARPROC &)QCAP_RESCALE_AUDIO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_RESCALE_AUDIO_BUFFER" );\
		(FARPROC &)QCAP_SOUNDRENDERER_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_SOUNDRENDERER_ENUMERATION" );\
		(FARPROC &)QCAP_SOUNDRENDERER_ENUMERATION_W = GetProcAddress( HANDLE_NAME, "QCAP_SOUNDRENDERER_ENUMERATION_W" );\

#endif
